require "prefabutil"

local assets=
{
	Asset("ANIM", "anim/cha.zip"),
	Asset("ANIM", "anim/teatree.zip"),
	Asset("ATLAS", "images/inventoryimages/cha.xml"),
}
	
local prefabs = {
	"spoiled_food",
	"teatree",
}

local function oneat(inst,eater)
	if eater.prefab == "pigman" or eater.prefab == "bunnyman" then eater.components.health:Kill() local p =  eater:GetPosition() SpawnPrefab("teatree").Transform:SetPosition(p.x,p.y,p.z) end
end
	
local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBuild("cha")
	inst.AnimState:SetBank("cha")
	inst.AnimState:PlayAnimation("cha", false)
    
    inst:AddTag("preparedfood")
	inst:AddTag("redtea")
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = 25
	inst.components.edible.hungervalue = 5
	inst.components.edible.foodtype = "GENERIC"
	inst.components.edible.foodstate = "PREPARED"
	inst.components.edible.sanityvalue = 10
	inst.components.edible.temperaturedelta = -3
	inst.components.edible:SetOnEatenFn(oneat)
	
	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/cha.xml"
	
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_PRESERVED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    local function OnDeploy (inst, pt)
	SpawnPrefab("teatree").Transform:SetPosition(pt.x, pt.y, pt.z)
		inst.components.stackable:Get():Remove()
	end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy

	
	MakeSmallBurnable(inst)
	MakeSmallPropagator(inst)
	---------------------        
	inst:AddComponent("bait")
    
	------------------------------------------------
	inst:AddComponent("tradable")
    
	------------------------------------------------  
    
	return inst
end
	
return Prefab( "common/inventory/cha", fn, assets, prefabs),
MakePlacer( "common/cha_placer", "teatree", "teatree", "sway" ) 