local Assets =
{
	Asset("ANIM", "anim/chaye.zip"),
    Asset("ATLAS", "images/inventoryimages/chaye.xml"), 
}

-- Write a local function that creats, customizes, and returns an instance of the prefab.
local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("chaye")
    inst.AnimState:SetBuild("chaye")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/chaye.xml"
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = 2
	inst.components.edible.hungervalue = 5
	inst.components.edible.sanityvalue = -1
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
	inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.MED_FUEL/1.1
	
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
		
	inst:AddComponent("inspectable")
    
    return inst
end

return Prefab( "common/inventory/chaye", fn, Assets)

