local Assets =
{
	Asset("ANIM", "anim/trinkets.zip"),
    Asset("ATLAS", "images/inventoryimages/iler.xml"), 
}

-- Write a local function that creats, customizes, and returns an instance of the prefab.
local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("trinkets")
    inst.AnimState:SetBuild("trinkets")
    inst.AnimState:PlayAnimation("19")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/iler.xml"
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = -5
	inst.components.edible.hungervalue = 3
	inst.components.edible.sanityvalue = -10
		
		inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
		
	inst:AddComponent("inspectable")
    
    return inst
end

return Prefab( "common/inventory/iler", fn, Assets)

