local Assets =
{
	Asset("ANIM", "anim/setqig.zip"),
}


local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeObstaclePhysics(inst, .4)
    inst.AnimState:SetBank("setqig")
    inst.AnimState:SetBuild("setqig")
    inst.AnimState:PlayAnimation("idle")
    

	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW*2)
	inst.components.perishable:StartPerishing()
	
	inst:DoPeriodicTask(30,function()
	local pos = inst:GetPosition()
	local ents = TheSim:FindEntities(pos.x,pos.y,pos.z,8)
	for k,v in ipairs(ents) do
	if v.components.pickable and not v:HasTag("rex") then v.components.pickable:LongUpdate(30) v:AddTag("rex") end
	end
end)
		
	inst:AddComponent("inspectable")
    
    return inst
end

return Prefab( "common/inventory/setqig", fn, Assets)

