local assets=
{
	Asset("ANIM", "anim/teatree.zip"),
	Asset("SOUND", "sound/common.fsb"),
}

local gr = "chaye"

local prefabs =
{
    ""..gr,
    --"dug_sapling",
}    

local function ontransplantfn(inst)
	inst.components.pickable:MakeEmpty()
end


local function dig_up(inst, chopper)
	if inst.components.pickable and inst.components.pickable:CanBePicked() then
		inst.components.lootdropper:SpawnLootPrefab(gr)
	end
	local bush = inst.components.lootdropper:SpawnLootPrefab(gr)
	inst:Remove()
end

local function onpickedfn(inst)
	--inst.AnimState:PlayAnimation("rustle") 
	inst.AnimState:PlayAnimation("empty", false) 
end

local function onregenfn(inst)
	--inst.AnimState:PlayAnimation("grow") 
	inst.AnimState:Playnimation("sway", true)
end

local function makeemptyfn(inst)
	inst.AnimState:PlayAnimation("empty",true)
end



local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local minimap = inst.entity:AddMiniMapEntity()
    inst.AnimState:SetRayTestOnBB(true);
    
    anim:SetBank("teatree")
    anim:SetBuild("teatree")
    anim:PlayAnimation("sway",true)
    anim:SetTime(math.random()*2)
	local s = 1.75
    inst.Transform:SetScale(s,s,s)

    inst:AddComponent("pickable")
    inst.components.pickable.picksound = "dontstarve/wilson/harvest_sticks"
    inst.components.pickable:SetUp(gr, TUNING.SAPLING_REGROW_TIME*1.5)
	inst.components.pickable.onregenfn = onregenfn
	inst.components.pickable.onpickedfn = onpickedfn
    inst.components.pickable.makeemptyfn = makeemptyfn
	inst.components.pickable.ontransplantfn = ontransplantfn

    inst:AddComponent("inspectable")
    
    
    
	inst:AddComponent("lootdropper")
	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.DIG)
    inst.components.workable:SetOnFinishCallback(dig_up)
    inst.components.workable:SetWorkLeft(1)

    
    MakeMediumBurnable(inst)
    MakeSmallPropagator(inst)
	MakeNoGrowInWinter(inst)    
    ---------------------   
    
    return inst
end

return Prefab( "forest/objects/teatree", fn, assets, prefabs) 
