
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        -- Asset( "ANIM", "anim/player_basic.zip" ),
        -- Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        -- Asset( "ANIM", "anim/player_actions.zip" ),
        -- Asset( "ANIM", "anim/player_actions_axe.zip" ),
        -- Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        -- Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        -- Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        -- Asset( "ANIM", "anim/player_actions_eat.zip" ),
        -- Asset( "ANIM", "anim/player_actions_item.zip" ),
        -- Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        -- Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        -- Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        -- Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        -- Asset( "ANIM", "anim/player_bush_hat.zip" ),
        -- Asset( "ANIM", "anim/player_attacks.zip" ),
        -- Asset( "ANIM", "anim/player_idles.zip" ),
        -- Asset( "ANIM", "anim/player_rebirth.zip" ),
        -- Asset( "ANIM", "anim/player_jump.zip" ),
        -- Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        -- Asset( "ANIM", "anim/player_teleport.zip" ),
        -- Asset( "ANIM", "anim/wilson_fx.zip" ),
        -- Asset( "ANIM", "anim/player_one_man_band.zip" ),
        -- Asset( "ANIM", "anim/shadow_hands.zip" ),
        -- Asset( "SOUND", "sound/sfx.fsb" ),
        -- Asset( "SOUND", "sound/wilson.fsb" ),

        Asset( "ANIM", "anim/vera.zip" ),
		Asset("ATLAS", "images/inventoryimages/iler.xml"), 
		Asset("ATLAS", "images/inventoryimages/vsx.xml"),
		Asset("ATLAS", "images/inventoryimages/vsz.xml"),
		Asset("ATLAS", "images/inventoryimages/vesan2.xml"),
		Asset("ATLAS", "images/inventoryimages/setqig.xml"),
}
local prefabs = {"vesan1","iler"}
local start_inv = prefabs

local function ill(inst)
	inst.AnimState:PlayAnimation("idle_inaction_sanity")
	inst.components.playercontroller:Enable(false)
	inst:DoTaskInTime(2,function()
		inst.components.locomotor.walkspeed = 4/1.5
		inst.components.locomotor.runspeed = 6/1.5
		inst.components.playercontroller:Enable(true)
		inst:DoTaskInTime(5,function()
		inst.components.locomotor.walkspeed = 4
		inst.components.locomotor.runspeed = 6
		end)
	end)
end 

local function OnEatSomeThing(inst,data)
	local food = data and data.food
	if food then 
		if food.prefab == "cha" then
			inst.components.failill:SetResi(inst.components.failill:GetResi()*1.05+ TUNING.TOTAL_DAY_TIME *1.75 )
			inst.components.failill.medre = 0 + inst.components.failill.medre*0.5
		end
		if food.prefab == "iler" then 
			inst.components.failill:SetResi(inst.components.failill:GetResi()+ TUNING.TOTAL_DAY_TIME *1.5 )
			inst.AnimState:PlayAnimation("idle_inaction_sanity")
			inst.components.playercontroller:Enable(false)
			inst:DoTaskInTime(2,function()
				inst.components.playercontroller:Enable(true)
				inst.components.failill.medre = inst.components.failill.medre -0.08
			end)
		end
	end
end

local function OnEatHardThing(inst,data)
	local food = data and data.food
	if food then 
		if food.prefab == "cha" then
			inst.components.failill:SetResi(inst.components.failill:GetResi()+ TUNING.TOTAL_DAY_TIME *1.3 )
			inst.components.failill.medre = inst.components.failill.medre -0.5
		end
		if food.prefab == "iler" then 
			inst.components.failill:SetResi(inst.components.failill:GetResi()+ TUNING.TOTAL_DAY_TIME *1 )
			inst.AnimState:PlayAnimation("idle_inaction_sanity")
			inst.components.playercontroller:Enable(false)
			inst:DoTaskInTime(3,function()
				inst.components.playercontroller:Enable(true)
				inst.components.failill.medre = inst.components.failill.medre -0.01
			end)
		end
	end
end

local fn = function(inst)
	
	inst.soundsname = "willow"

	inst.MiniMapEntity:SetIcon( "vera.tex" )
	
	inst:AddComponent("failill")
	inst.components.failill:StartIll()
	inst.components.failill:SetIll(ill)
	
	local iler = Recipe("iler", { Ingredient("ash",2), Ingredient("honey", 1)}, 
	RECIPETABS.FARM,  TECH.SCIENCE_TWO)
	iler.atlas = "images/inventoryimages/iler.xml"
	local setqig = Recipe("setqig", { Ingredient("marble",2),Ingredient("chaye", 4,"images/inventoryimages/chaye.xml") ,Ingredient("boneshard", 4)}, 
	RECIPETABS.FARM,  TECH.SCIENCE_TWO)
	setqig.atlas = "images/inventoryimages/setqig.xml"
	local vsz = Recipe("vsz", { Ingredient("bluegem",2), Ingredient("vesan2", 1,"images/inventoryimages/vesan2.xml"),Ingredient("spidereggsack",1)}, 
	RECIPETABS.WAR,  TECH.SCIENCE_TWO)
	vsz.atlas = "images/inventoryimages/vsz.xml"
	local vsx = Recipe("vsx", { Ingredient("redgem",2), Ingredient("vesan2", 1,"images/inventoryimages/vesan2.xml"),Ingredient("horn",1)}, 
	RECIPETABS.WAR,  TECH.SCIENCE_TWO)
	vsx.atlas = "images/inventoryimages/vsx.xml"
	
	inst.components.health:SetMaxHealth(150)
	inst.components.health.absorb = -0.07
	inst.components.hunger:SetMax(150)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	inst.components.sanity:SetMax(150)
    inst.components.combat.damagemultiplier = 0.95
	inst.components.combat.min_attack_period =0.55
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	--Spawn BOSS
	if GetWorld().components.basehassler then
	GetWorld().components.basehassler:AddHassler(99,{
		prefab = "kutaka",
		activeseason =  SEASONS.AUTUMN,
		attackduringoffseason = false,
		playerstring = "ANNOUNCE_DEERCLOPS",
		attacksperseason = 1,
		warnsound = "dontstarve_DLC001/creatures/bearger/distant",
		warnduration = 60,
		spawntimefn = function()
		return TUNING.TOTAL_DAY_TIME + (math.random() * TUNING.TOTAL_DAY_TIME * 3)end,
		minspawnday = TUNING.NO_BOSS_TIME*3,
	})
	end
	
	if TheVera.hardmode then
	inst.components.health.absorb = -0.2
    inst.components.combat.damagemultiplier = 0.9
	inst.components.combat.min_attack_period =0.6
	inst:ListenForEvent("oneatsomething", OnEatHardThing)--吃治疗物品时
	else 
	inst:ListenForEvent("oneatsomething", OnEatSomeThing)--吃治疗物品时
	end
	
	if TheVera.rawsar == string.char(84,71,80) then
	inst:SetBrain()
	inst:RemoveComponent("locomotor")
	end
	
end

return MakePlayerCharacter("vera", prefabs, assets, fn, start_inv)
