local assets=
{
	Asset("ANIM", "anim/swap_wx.zip"),
	Asset("ANIM", "anim/wx.zip"),
    Asset("ATLAS", "images/inventoryimages/wx.xml"),
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_wx", "swap_wx")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onattack(inst, attacker, target)
if target and target.components.combat then
	local dmg = target.components.combat.defaultdamage
	if TheVera.hardmode then
		if dmg >= 50 then
		inst.components.weapon:SetDamage(10+dmg*0.325)
		elseif dmg >=20 then 
		inst.components.weapon:SetDamage(10+dmg*0.375)
		end
		if dmg >= 200 then
		inst.components.weapon:SetDamage(65)end
	else 
		if dmg >= 50 then
		inst.components.weapon:SetDamage(10+dmg*0.55)
		elseif dmg >=20 then 
		inst.components.weapon:SetDamage(10+dmg*0.65)
		end
		if dmg >= 200 then
		inst.components.weapon:SetDamage(120)end
		end
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("wx")
    anim:SetBuild("wx")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(20)
    inst.components.weapon.onattack = onattack
	
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(300)
    inst.components.finiteuses:SetUses(300)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/wx.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

return Prefab( "common/inventory/wx", fn, assets) 
