-- This information tells other players more about the mod
name = "A Winona the gatherer"
description = "test1"
author = "Dr. Lalaoz"
version = "1.4.0" -- This is the version of the template. Change it to your own number.

-- This is the URL name of the mod's thread on the forum; the part after the ? and before the first & in the url
forumthread = ""


-- This lets other players know if your mod is out of date, update it to match the current version in the game
api_version = 10

-- Compatible with Don't Starve Together
dst_compatible = true

-- Not compatible with Don't Starve
dont_starve_compatible = false
reign_of_giants_compatible = false

-- Character mods need this set to true
all_clients_require_mod = true 

icon_atlas = "modicon.xml"
icon = "modicon.tex"

-- The mod's tags displayed on the server list
server_filter_tags = {
"character",
}

TrueFalse = {
	"True", true,
	"False", false,
}
StatOptions = {
	"50",50,
	"75",75,
	"100",100,
	"125",125,
	"150",150,
	"175",175,
	"200",200,
	"225",225,
	"250",250,
	"275",275,
	"300",300,
}

DamagePenaltyOptions = {
	"Normal Damage", 1,
	"-5%",0.95,
	"-10%",0.9,
	"-15%",0.85,
	"-20%",0.8,
	"-25%",0.75,
	"-30%",0.7,
	"-35%",0.65,
	"-40% (Default)",0.6,
	"-45%",0.55,
	"-50%",0.5,
	"-55%",0.45,
	"-60%",0.4,
	"-65%",0.45,
	"-70%",0.30,
	"-75%",0.25,
	"-80%",0.2,
	"-85%",0.15,
	"-90%",0.1,
	"-95%",0.05,
	"Winona Does no damage",0,
}
DamageVulnerabilityOptions = {
	"No Bonus", 1,
	"+5%",1.05,
	"+10%",1.1,
	"+15%",1.15,
	"+20%",1.2,
	"+25%",1.25,
	"+30% (Default)",1.3,
	"+35%",1.35,
	"+40%",1.4,
	"+45%",1.45,
	"+50%",1.50,
	"+55%",1.55,
	"+60%",1.6,
	"+65%",1.65,
	"+70%",1.7,
	"+75%",1.75,
	"+80%",1.8,
	"+85%",1.85,
	"+90%",1.9,
	"+95%",1.95,
	"+100%",2,
}
SpeedOptions = {
	"No Bonus", 1,
	"+5%",1.05,
	"+10%",1.1,
	"+15%",1.15,
	"+20%",1.2,
	"+25% (Default)",1.25,
	"+30%",1.3,
	"+35%",1.35,
	"+40%",1.4,
	"+45%",1.45,
	"+50%",1.5,
}
HungerOptions = {
	"Normal Hunger", 1,
	"-5%",0.95,
	"-10%",0.9,
	"-15%",0.85,
	"-20%",0.8,
	"-25%",0.75,
	"-30%",0.7,
	"-35%",0.65,
	"-40%",0.6,
	"-45%",0.55,
	"-50% (Default)",0.5,
	"-55%",0.45,
	"-60%",0.4,
	"-65%",0.45,
	"-70%",0.30,
	"-75%",0.25,
	"-80%",0.2,
	"-85%",0.15,
	"-90%",0.1,
	"-95%",0.05,
	"Winona Doesn't Eat",0,
}

ChanceOptions1_100 = {
	"0% (Never)",  0,
	"5%",  5,
	"10%",10,
	"15%",15,
	"20%",20,
	"25%",25,
	"30%",30,
	"35%",35,
	"40%",40,
	"45%",45,
	"50%",50,
	"55%",55,
	"60%",60,
	"65%",65,
	"70%",70,
	"75%",75,
	"80%",80,
	"85%",85,
	"90%",90,
	"95%",95,
	"100% (Always)",100,
}
function CreateOptions(List)
	local Options = {}
	for i=1,#List/2 do
		Options[i] = {description = List[(i*2)-1],data = List[(i*2)]}
	end
	return Options
end
configuration_options = {
	{
	label    = "Speed Modifier",
    name   = "speedmod",
	hover	= "Change the speed modifier",
    options = CreateOptions(SpeedOptions),
    default = 1.25,
	},{
	label    = "Hunger Rate",
    name    = "hungermod",
	hover	= "What modifiers to the hunger rate",
    options = CreateOptions(HungerOptions),
    default = 0.5,
	},{
	label    = "Double Pick",
    name   = "2pickmod",
	hover	= "Chance for double pick on grass, twigs, ect.",
    options = CreateOptions(ChanceOptions1_100),
    default = 100,
	},{
	label    = "Triple Pick",
    name   = "3pickmod",
	hover	= "Chance for Triple pick, (will override double if succeded)",
    options = CreateOptions(ChanceOptions1_100),
    default = 0,
	},--[[{
	-- doesnt turn off, even if you dont put the tag on in the first place. its wierd. dont have time to figure it out right now but it'll come later.
	-- leave a fix in the comments if you have one <3
	label    = "Woodie Chop Speed",
    name   = "chopspeedmod",
	hover	= "Enable/Disable woodies faster woodchopping speed",
    options = CreateOptions(TrueFalse),
    default = true,
	},]]{
	label    = "Double Tools Power",
    name   = "2toolpower",
	hover	= "Chance to do double hit to a tree, rock, ect.",
    options = CreateOptions(ChanceOptions1_100),
    default = 100,
	},{
	label    = "Triple Tools Power",
    name   = "3toolpower",
	hover	= "Chance to do triple hit, (will override double if succeded)",
    options = CreateOptions(ChanceOptions1_100),
    default = 0,
	},{
	label    = "DamagePenalty",
    name   = "damagedeltmod",
	hover	= "Chance to do triple hit, (will override double if succeded)",
    options = CreateOptions(DamagePenaltyOptions),
    default = 0.6,
	},{
	label    = "DamageVulnerability",
    name   = "damagetakenmod",
	hover	= "How much extra damage winona takes",
    options = CreateOptions(DamageVulnerabilityOptions),
    default = 1.3,
	},{
	label    = "Health",
    name   = "healthset",
	hover	= "How much max health to give winona",
    options = CreateOptions(StatOptions),
    default = 100,
	},{
	label    = "Sanity",
    name   = "sanityset",
	hover	= "How much max sanity to give winona",
    options = CreateOptions(StatOptions),
    default = 150,
	},{
	label    = "Hunger",
    name   = "hungerset",
	hover	= "How much max hunger to give winona",
    options = CreateOptions(StatOptions),
    default = 100,
	},
}
