PrefabFiles = {
	"wukong",
	"ruyibang",
	"monkeykingcrown",
	"jindouyun",
	"pantao",
	"pantaoyan",
	"pantao_seeds"
}

Assets = {
    Asset( "ANIM", "anim/monkeykingcrown.zip" ),
	Asset( "ANIM", "anim/wukong.zip" ),
	Asset( "ANIM", "anim/wukongH.zip" ),
	Asset( "ANIM", "anim/ruyibang.zip" ),
	Asset( "ANIM", "anim/swap_ruyibang.zip" ),
    Asset( "ANIM", "anim/jindouyun.zip" ),
	Asset( "ANIM", "anim/flotsam_jindouyun_build.zip" ),
	Asset( "ANIM", "anim/pantao.zip" ),
	Asset( "ANIM", "anim/pantaoyan.zip" ),
	
    Asset( "IMAGE", "images/saveslot_portraits/wukong.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/wukong.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/wukong.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wukong.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/wukong_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wukong_silho.xml" ),

    Asset( "IMAGE", "bigportraits/wukong.tex" ),
    Asset( "ATLAS", "bigportraits/wukong.xml" ),
	
	Asset( "IMAGE", "images/map_icons/wukong.tex" ),
	Asset( "ATLAS", "images/map_icons/wukong.xml" ),
	
	Asset( "IMAGE", "images/map_icons/ruyibang.tex" ),
	Asset( "ATLAS", "images/map_icons/ruyibang.xml" ),
	
	Asset( "IMAGE", "images/map_icons/jindouyun.tex" ),
	Asset( "ATLAS", "images/map_icons/jindouyun.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/monkeykingcrown.tex" ),
	Asset( "ATLAS", "images/inventoryimages/monkeykingcrown.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/ruyibang.tex" ),
	Asset( "ATLAS", "images/inventoryimages/ruyibang.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/jindouyun.tex" ),
	Asset( "ATLAS", "images/inventoryimages/jindouyun.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/pantao.tex" ),
	Asset( "ATLAS", "images/inventoryimages/pantao.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/pantao_seeds.tex" ),
	Asset( "ATLAS", "images/inventoryimages/pantao_seeds.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/pantaoyan.tex" ),
	Asset( "ATLAS", "images/inventoryimages/pantaoyan.xml" ),
	
	--Asset( "IMAGE", "images/tabs/meihouwang.tex" ),
	--Asset( "ATLAS", "images/tabs/meihouwang.xml" ),
	
}

local require = GLOBAL.require
local GetPlayer = GLOBAL.GetPlayer
local Recipe = GLOBAL.Recipe
local TUNING = GLOBAL.TUNING
local Ingredient = GLOBAL.Ingredient


GLOBAL.STRINGS.NAMES.RUYIBANG = "JingGuBang"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.RUYIBANG= "Wukong's Powerful Magical Staff"

GLOBAL.STRINGS.NAMES.MONKEYKINGCROWN = "MeiHouWangGuan"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.MONKEYKINGCROWN= "The Monkey King Crown"

GLOBAL.STRINGS.NAMES.JINDOUYUN = "JingDouYun"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.JINDOUYUN= "The Way Wukong Travels"

GLOBAL.STRINGS.NAMES.JINDOUYUN_ITEM = "JingDouYun"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.JINDOUYUN_ITEM= "The Way Wukong Travels"

GLOBAL.STRINGS.NAMES.PANTAO = "PanTao"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.PANTAO= "Wukong's favorite food"

GLOBAL.STRINGS.NAMES.PANTAOYAN = "PanTaoYan"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.PANTAOTAN= "Wukong's favorite food from the Skypalace"

GLOBAL.STRINGS.NAMES.PANTAO_SEEDS = "PanTao_Seeds"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.PANTAO_SEEDS= "The Seeds of PanTao"

-- The character select screen lines
GLOBAL.STRINGS.CHARACTER_TITLES.wukong = "The Monkey King"
GLOBAL.STRINGS.CHARACTER_NAMES.wukong = "Wukong"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.wukong = "*is a monk and a strong monkey \n*Wields a powerful magical staff \n*And many others"
GLOBAL.STRINGS.CHARACTER_QUOTES.wukong = "\"I will be the best\""



AddMinimapAtlas("images/map_icons/wukong.xml")
AddMinimapAtlas("images/map_icons/ruyibang.xml")
AddMinimapAtlas("images/map_icons/jindouyun.xml")


AddModCharacter("wukong")

--[[AddClassPostConstruct("widgets/crafttabs", function(inst)
    if inst.prefab == "wukong" then
    GLOBAL.RECIPETABS['wukong'] = {str = "wukong", sort= 99, icon = "meihouwang.tex", icon_atlas = "images/tabs/meihouwang.xml"}
	table.insert(tabnames, GLOBAL.RECIPETABS['wukong'])
    end
end)--]]

local driver = require "components/driver"
local old_OnMount = driver.OnMount
function driver:OnMount(vehicle,...)
	local res = old_OnMount(self,vehicle,...)
	if vehicle and vehicle.prefab == "jindouyun" then
		-- self.inst.AnimState:OverrideSymbol("shadow","jindouyun","shadow")
		self.inst.components.locomotor.hasmomentum = false
	end
	return res
end

local pantaoyan =
	{
	    name = "pantaoyan",
		test = function(cooker, names, tags) return names.pantao and names.pantao > 2 and tags.fruit and tags.fruit > 3 end,
		priority = 50,
		weight = 1,
		foodtype = "VEGGIE",
		health = 60,
		hunger = 150,
		perishtime = TUNING.PERISH_MED,
		sanity = 50,
		naughtyvalue = 15,
		cooktime = 0.5,
	}
	
AddCookerRecipe("cookpot", pantaoyan)



local function pickproduct(inst)
	
local VEGGIES = 
{	
	cave_banana = {seed_weight = 0,},
	carrot = {seed_weight = 3,},
	corn = {seed_weight = 3,},	
	pumpkin = {seed_weight = 1,},
	eggplant = {seed_weight = 1,},	
	durian = {seed_weight = 0.5,},	
	pomegranate = {seed_weight = 0.5,},	
	dragonfruit = {seed_weight = 0.5,},
	berries = {seed_weight = 0,},
	cactus_meat = {seed_weight = 0,},
	watermelon = {seed_weight = 1,},
	coffeebeans = {seed_weight = 0,},
	sweet_potato = {seed_weight = 3,},	
	pantao = {seed_weight = 0.5,},
}

	local total_w = 0
	for k,v in pairs(VEGGIES) do
		total_w = total_w + (v.seed_weight or 1)
	end
	
	local rnd = math.random()*total_w
	for k,v in pairs(VEGGIES) do
		rnd = rnd - (v.seed_weight or 1)
		if rnd <= 0 then
			return k
		end
	end
	
	return "carrot"
end

AddPrefabPostInit("seeds",function(inst)
if GetPlayer().prefab == "wukong" then
	inst.components.plantable.product = pickproduct
end
end
)

AddPrefabPostInit("solofish",function(inst)
if GetPlayer().prefab == "wukong" then
	inst:AddTag("smallfish")
end
end
)

--[[local function init_chester(inst)
	if GLOBAL.GetPlayer().prefab == "wukong" then
		inst:AddTag("notarget")
		--table.remove(inst.components.health)
		inst:RemoveComponent("combat")
	end
end
AddPrefabPostInit("chester", init_chester)

local function init_packim(inst)
	if GLOBAL.GetPlayer().prefab == "wukong" then
		inst:AddTag("notarget")
		table.remove(inst.components.health)
		--inst:RemoveComponent("combat")
	end
end
AddPrefabPostInit("packim", init_packim)--]]

AddIngredientValues({"pantao"}, {fruit=1}, false, false)