require "prefabutil"


local prefabs =
{
	"rowboat_wake",
	"boat_hit_fx",
	"boat_hit_fx_raft_log",
	"boat_hit_fx_raft_bamboo",
	"boat_hit_fx_rowboat",
	"boat_hit_fx_cargoboat",
	"boat_hit_fx_armoured",
	"flotsam_armoured",
	"flotsam_bamboo",
	"flotsam_cargo",
	"flotsam_lograft",
	"flotsam_rowboat",
	"flotsam_surfboard",
}



local assets =
{
	Asset("ANIM", "anim/raft_surfboard_build.zip"),
	Asset("ANIM", "anim/jindouyun.zip"),
	Asset("ANIM", "anim/boat_hud_raft.zip"), 
	Asset("ANIM", "anim/boat_inspect_raft.zip"), 
	Asset("ANIM", "anim/flotsam_jindouyun_build.zip"),
	Asset( "IMAGE", "images/inventoryimages/jindouyun.tex" ),
	Asset( "ATLAS", "images/inventoryimages/jindouyun.xml" ),
}


local function boat_perish(inst)



	if inst.components.drivable.driver then

		local driver = inst.components.drivable.driver

		driver.components.driver:OnDismount(true)

		driver.components.health:Kill("drowning")

		inst.SoundEmitter:PlaySound(inst.sinksound)


		inst:Remove()
	end
end



local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("run_loop", true)
end

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

--[[local function onmounted(inst)
	--print("I'm getting mounted!")
	inst:RemoveComponent("workable")  
end 

local function ondismounted(inst)
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
    inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit)
end --]]

local function onopen(inst)
	if inst.components.drivable.driver == nil then
		inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/HUD_boat_inventory_open")
	end
end

local function onclose(inst)
	if inst.components.drivable.driver == nil then
		inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/HUD_boat_inventory_close")
	end
end

local function setupcontainer(inst, slots, bank, build, inspectslots, inspectbank, inspectbuild, inspectboatbadgepos, inspectboatequiproot)
	inst:AddComponent("container")
	inst.components.container:SetNumSlots(#slots)
	inst.components.container.type = "boat"
	inst.components.container.side_align_tip = -500
	inst.components.container.canbeopened = false
	inst.components.container.onopenfn = onopen
	inst.components.container.onclosefn = onclose

	inst.components.container.widgetslotpos = slots
	inst.components.container.widgetanimbank = bank
	inst.components.container.widgetanimbuild = build
	inst.components.container.widgetboatbadgepos = Vector3(0, 40, 0)
	inst.components.container.widgetequipslotroot = Vector3(-80, 40, 0)


	local boatwidgetinfo = {}
	boatwidgetinfo.widgetslotpos = inspectslots
	boatwidgetinfo.widgetanimbank = inspectbank
	boatwidgetinfo.widgetanimbuild = inspectbuild
	boatwidgetinfo.widgetboatbadgepos = inspectboatbadgepos
	boatwidgetinfo.widgetpos = Vector3(200, 0, 0)
	boatwidgetinfo.widgetequipslotroot = inspectboatequiproot
	inst.components.container.boatwidgetinfo = boatwidgetinfo
end 




local function commonfn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	trans:SetFourFaced()
	inst.no_wet_prefix = true 

	inst:AddTag("boat")

	local anim = inst.entity:AddAnimState()
	
	inst.entity:AddSoundEmitter()

	inst.entity:AddPhysics()
	inst.Physics:SetCylinder(0.25,2)

	inst:AddComponent("inspectable")
	inst:AddComponent("drivable")
	
	-- inst.waveboost = TUNING.WAVEBOOST

	inst:AddComponent("rowboatwakespawner")

	inst:AddComponent("boathealth")
	inst.components.boathealth:SetDepletedFn(boat_perish)
    inst:AddComponent("repairable")
    inst.components.repairable.repairmaterial = "boat"

	return inst
end

local function pickupfn(inst, guy)
	local board = SpawnPrefab("jindouyun_item")
	guy.components.inventory:GiveItem(board)
	board.components.pocket:GiveItem("jindouyun", inst)
	return true
end

local function ondeploy(inst, pt, deployer)
	local board = inst.components.pocket:RemoveItem("jindouyun") or SpawnPrefab("jindouyun") 

	if board then
		pt = Vector3(pt.x, 0, pt.z)
		board.Physics:SetCollides(false)
		board.Physics:Teleport(pt.x, pt.y, pt.z) 
		board.Physics:SetCollides(true)
		inst:Remove()
		return board
	end
end



local function jindouyun_fn(sim)

	local inst = commonfn(sim)

	setupcontainer(inst, {}, "boat_hud_raft", "boat_hud_raft", {}, "boat_inspect_raft", "boat_inspect_raft", {x=0,y=5}, {})

	inst.AnimState:SetBank("raft")
	inst.AnimState:SetBuild("jindouyun")
	inst.AnimState:PlayAnimation("run_loop", true)

	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetPriority( 5 )
	minimap:SetIcon("jindouyun.tex")
	
	inst.components.boathealth.maxhealth = 300
	inst.components.boathealth:SetHealth(300, TUNING.ARMOUREDBOAT_PERISHTIME)
    inst.components.boathealth.damagesound = "dontstarve_DLC002/common/surfboard_damage"
	-- inst.components.boathealth.invincible = true
	
	inst.landsound = "dontstarve_DLC002/common/boatjump_land_wood"
	inst.sinksound = "dontstarve_DLC002/common/boat_sinking_log_cargo"
	inst.sailsound = "common/surfboard_sail_LP"
	
	inst.sailmusic = "sailing"
	
	
	
	inst.components.drivable.sanitydrain = 0
	inst.components.drivable.runspeed = 2
	inst.components.drivable.maprevealbonus = 8
	inst.components.drivable.hitfx = "boat_hit_fx_armoured"
	inst.components.drivable.runanimation = "row_loop" 
	inst.components.drivable.prerunanimation = "row_pre"
	inst.components.drivable.postrunanimation = "row_pst"
	inst.components.drivable.overridebuild = "jindouyun"
	inst.components.drivable.flotsambuild = "flotsam_jindouyun_build"
	inst.components.drivable.creaksound = "dontstarve_DLC002/common/boat_creaks"
	inst.components.drivable.alwayssail = true

	inst.waveboost = 0

	inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("wukong")

	inst:AddComponent("pickupable")
	inst.components.pickupable:SetOnPickupFn(pickupfn)
	inst:SetInherentSceneAltAction(ACTIONS.RETRIEVE)

	return inst
end 



local function deploytest(inst, pt)
	------------------------------------------------------
	-- MAKE SURE THIS TEST MATCHES THE BUILDER.LUA TEST --
	------------------------------------------------------
	local ground = GetWorld()
	local tile = GROUND.GRASS
	if ground and ground.Map then
		tile = ground.Map:GetTileAtPoint(pt:Get())
	end

	local onWater = ground.Map:IsWater(tile)

	return onWater
end

local function jindouyun_ondropped(inst)
	--If this is a valid place to be deployed, auto deploy yourself.
	if inst.components.deployable and inst.components.deployable:CanDeploy(inst:GetPosition()) then
		inst.components.deployable:Deploy(inst:GetPosition(), inst)
	end
end

local function jindouyun_item_fn(Sim)

	local inst = CreateEntity()

	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetPriority( 5 )
	minimap:SetIcon("jindouyun.tex")

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)

	inst:AddTag("boat")
	
	inst.AnimState:SetBank("raft") 
	inst.AnimState:SetBuild("jindouyun") 
	inst.AnimState:PlayAnimation("idle")

	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "jindouyun"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/jindouyun.xml"
	
	inst.components.inventoryitem:SetOnDroppedFn(jindouyun_ondropped)

	inst:AddComponent("pocket")

	inst:AddComponent("deployable")
	inst.components.deployable.ondeploy = ondeploy
	inst.components.deployable.placer = "jindouyun_placer" 
	inst.components.deployable.test = deploytest
	inst.components.deployable.deploydistance = 3


	inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("wukong")

	return inst
end


return 
	Prefab( "common/objects/jindouyun", jindouyun_fn, assets, prefabs),
	Prefab("common/jindouyun_item", jindouyun_item_fn, assets, prefabs),
	MakePlacer( "common/jindouyun_placer", "raft", "jindouyun", "run_loop", false, false, false, nil, nil, nil, nil, true)