local assets=
{
Asset("ANIM", "anim/monkeykingcrown.zip"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "monkeykingcrown", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")
	
	if owner:HasTag("player") then
		owner.AnimState:Hide("HEAD")
		owner.AnimState:Show("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StartConsuming()
	end
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StopConsuming()
	end
	
	
end

local function monkeyking_update(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if owner and owner.components.farseer then
		local boating = false
		if owner.components.driver and owner.components.driver:GetIsDriving() then
			boating = true
		end
		if not boating then
			if owner and owner.components.leader and owner:HasTag("player") then
				local x,y,z = owner.Transform:GetWorldPosition()
				local ents = TheSim:FindEntities(x,y,z, 10, {"primeape"})
				for k,v in pairs(ents) do
					if v.components.follower and not v.components.follower.leader and not owner.components.leader:IsFollower(v) and owner.components.leader.numfollowers < 5 then
						if v.components.combat.target and v.components.combat.target == owner then
							v.components.combat:SetTarget(nil)
						end		
						owner.components.leader:AddFollower(v)
						v.sg:GoToState("befriend")
						v.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
					end
				end
			end
		else
			if owner and owner.components.leader then
				owner.components.leader:RemoveFollowersByTag("primeape")
			end
		end
	end
	
end

local function monkeyking_enable(inst)
	inst.updatetask = inst:DoPeriodicTask(0.5, monkeyking_update, 1)
end

local function monkeyking_disable(inst)
	if inst.updatetask then
		inst.updatetask:Cancel()
		inst.updatetask = nil
	end
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if owner and owner.components.leader then
		owner.components.leader:RemoveFollowersByTag("primeape")
	end
end

local function monkeykingcrown_equip(inst, owner)
	onequip(inst, owner)
	monkeyking_enable(inst)
end

local function monkeykingcrown_unequip(inst, owner)
	onunequip(inst, owner)
	monkeyking_disable(inst)
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("monkeykingcrown")
	inst.AnimState:SetBuild("monkeykingcrown")
	inst.AnimState:PlayAnimation("anim")
	MakeInventoryFloatable(inst, "idle_water", "anim")
	inst:AddTag("hat")
	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/monkeykingcrown.xml"
	inst.components.inventoryitem:SetOnDroppedFn( monkeyking_disable )
	inst:AddComponent("tradable")
	inst:AddComponent("equippable")
	-- inst.components.equippable.insulated = true
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( monkeykingcrown_equip )
	inst.components.equippable:SetOnUnequip( monkeykingcrown_unequip )
	
	inst:AddComponent("characterspecific")
	inst.components.characterspecific:SetOwner("wukong")
	
	-- inst.components.equippable.dapperness = TUNING.DAPPERNESS_LARGE
	
	inst:AddComponent("armor")
	inst.components.armor:InitCondition(800, 0.8)
	return inst
end

return Prefab( "common/inventory/monkeykingcrown", fn, assets )