assets =
{
	Asset("ANIM", "anim/seeds.zip"),
	Asset("IMAGE", "images/inventoryimages/pantao_seeds.tex"),
	Asset("ATLAS", "images/inventoryimages/pantao_seeds.xml"),
}
prefabs = 
{
"spoiled_food"
}


local function fn()
	local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
	    
		MakeInventoryPhysics(inst)
		MakeBlowInHurricane(inst, TUNING.WINDBLOWN_SCALE_MIN.LIGHT, TUNING.WINDBLOWN_SCALE_MAX.LIGHT)
		inst.AnimState:SetBank("seeds")
		inst.AnimState:SetBuild("seeds")
		inst.AnimState:SetRayTestOnBB(true)
		inst.AnimState:PlayAnimation("idle")

    MakeInventoryFloatable(inst, "idle_water", "idle")
	    
		inst:AddComponent("edible")
		inst.components.edible.foodtype = "SEEDS"
		inst.components.edible.foodstate = "RAW"

		inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

		
		inst:AddComponent("tradable")
		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.atlasname = "images/inventoryimages/pantao_seeds.xml"
	    

		inst.components.edible.healthvalue = TUNING.HEALING_TINY/2
		inst.components.edible.hungervalue = TUNING.CALORIES_TINY

		inst:AddComponent("perishable")
		inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERSLOW)
		inst.components.perishable:StartPerishing()
		inst.components.perishable.onperishreplacement = "spoiled_food"
		
	    
		inst:AddComponent("cookable")
		inst.components.cookable.product = "seeds_cooked"
	    
		inst:AddComponent("bait")
		inst:AddComponent("plantable")
		inst.components.plantable.growtime = TUNING.SEEDS_GROW_TIME
		inst.components.plantable.product = "pantao"
	    
		return inst
end


return Prefab( "common/inventory/pantao_seeds", fn, assets, prefabs)