assets =
{
	Asset("ANIM", "anim/pantaoyan.zip"),
	Asset("IMAGE", "images/inventoryimages/pantaoyan.tex"),
	Asset("ATLAS", "images/inventoryimages/pantaoyan.xml"),
}
local prefabs = 
	{
	"spoiled_food"
	}


local function fn()
	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst:AddTag("preparedfood")
	

	
    inst.AnimState:SetBank("pantaoyan")
    inst.AnimState:SetBuild("pantaoyan")
    inst.AnimState:PlayAnimation("pantaoyan", false)
	MakeInventoryFloatable(inst, "pantaoyan_water", "pantaoyan")
	
	inst:AddComponent("inspectable")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/pantaoyan.xml"
	
	inst:AddComponent("tradable")
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = 60
	inst.components.edible.hungervalue = 150
	inst.components.edible.sanityvalue = 50
	inst.components.edible.naughtyvalue = 15
	inst.components.edible.foodtype = "VEGGIE"
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
	return inst
end


return Prefab( "common/inventory/pantaoyan", fn, assets, prefabs)