local assets=
{
Asset("ANIM", "anim/ruyibang.zip"),
Asset("ANIM", "anim/swap_ruyibang.zip"),

Asset("ATLAS", "images/inventoryimages/ruyibang.xml"),
Asset("IMAGE", "images/inventoryimages/ruyibang.tex"),
}
prefabs = {
}

local level_max = 25


local function levelup(inst)
	local damage = math.ceil(34 + 34 * inst.level / level_max)
	local attackrange = math.ceil(inst.level * 3 / level_max)
	local hitrange = math.ceil(inst.level * 4 / level_max)
    inst.components.weapon:SetDamage(damage)
	inst.components.weapon:SetRange(attackrange, hitrange)
end

local function onattack(inst, attacker, target)
	if attacker and attacker.level and inst.level < attacker.level then
		inst.level = attacker.level
		levelup(inst)
	end
end


local function OnEquip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_ruyibang", "swap_ruyibang")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
	--inst.updatetask = inst:DoPeriodicTask(0.5, update, 1)
end
	
local function OnUnequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
--[[	if inst.updatetask then
		inst.updatetask:Cancel()
		inst.updatetask = nil
	end--]]
end

local function onpreload(inst, data)
	if data and data.level then
		inst.level = data.level
		levelup(inst)
    end
end


local function onsave(inst, data)
	data.level = inst.level
end

local function toolon(inst)
	inst:AddTag("tool")
	inst:RemoveTag("toolless")
	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP,15)
	inst.components.tool:SetAction(ACTIONS.MINE,8)
	inst.components.tool:SetAction(ACTIONS.HAMMER,4)
	--inst.components.tool:SetAction(ACTIONS.HACK,6)
	--inst.components.tool:SetAction(ACTIONS.DIG,8)
	inst.components.talker:Say("toolon")
end

local function tooloff(inst)
	inst:AddTag("toolless")
	inst:RemoveTag("tool")
	inst:RemoveComponent("tool")
	inst.components.talker:Say("tooloff")	
end


local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	
	
	anim:SetBank("ruyibang")
	anim:SetBuild("ruyibang")
	anim:PlayAnimation("idle")
	
	inst:AddComponent("weapon")
	--inst.components.weapon:SetDamage(50)
	--inst.components.weapon:SetRange(3, 4)
	inst.components.weapon:SetOnAttack(onattack)
	inst:AddTag("toolless")	
	inst:AddComponent("inventoryitem")
	
	inst.components.inventoryitem.imagename = "ruyibang"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/ruyibang.xml"
	
	inst:AddComponent("characterspecific")
	inst.components.characterspecific:SetOwner("wukong")
	
	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip( OnEquip )
	inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst:AddComponent("talker")
	
	TheInput:AddKeyUpHandler(KEY_Z, function()
	if inst:HasTag("toolless") then 
		toolon(inst) 
	elseif inst:HasTag("tool") then 
		tooloff(inst)
	end
	end)
	
	inst.level = 0
	levelup(inst)
	
	inst.OnSave = onsave
    inst.OnPreLoad = onpreload
	
	
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "ruyibang.tex" )
	
	return inst
end
return  Prefab("common/inventory/ruyibang", fn, assets, prefabs)