local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

Asset( "ANIM", "anim/player_basic.zip" ),
Asset( "ANIM", "anim/player_idles_shiver.zip" ),
Asset( "ANIM", "anim/player_actions.zip" ),
Asset( "ANIM", "anim/player_actions_axe.zip" ),
Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
Asset( "ANIM", "anim/player_actions_shovel.zip" ),
Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
Asset( "ANIM", "anim/player_actions_eat.zip" ),
Asset( "ANIM", "anim/player_actions_item.zip" ),
Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
Asset( "ANIM", "anim/player_actions_fishing.zip" ),
Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
Asset( "ANIM", "anim/player_bush_hat.zip" ),
Asset( "ANIM", "anim/player_attacks.zip" ),
Asset( "ANIM", "anim/player_idles.zip" ),
Asset( "ANIM", "anim/player_rebirth.zip" ),
Asset( "ANIM", "anim/player_jump.zip" ),
Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
Asset( "ANIM", "anim/player_teleport.zip" ),
Asset( "ANIM", "anim/wilson_fx.zip" ),
Asset( "ANIM", "anim/player_one_man_band.zip" ),
Asset( "ANIM", "anim/shadow_hands.zip" ),
Asset( "SOUND", "sound/sfx.fsb" ),
Asset( "SOUND", "sound/wilson.fsb" ),
Asset( "ANIM", "anim/beard.zip" ),

Asset( "ANIM", "anim/wukong.zip" ),
Asset( "ANIM", "anim/wukongH.zip" ),
}
local prefabs = {}

local start_inv = {
"jindouyun_item",
"monkeykingcrown",
}

local level_max = 25
local level_bang = 3
local level_yan = 6
local chance_normal = 0.05
local chance_big = 0.25
local chance_boss = 0.5
local change_multdam = 0.3

--ж
local function isanimals(target)
	return (target:HasTag("animal") or target:HasTag("bird") or target:HasTag("insect") or target:HasTag("smallfish"))
end

local function iskillers(target)
	return (target:HasTag("killer") or target:HasTag("rocky") or target:HasTag("tallbird") or target:HasTag("mosquito") or target:HasTag("epic") or target:HasTag("mossling") or target:HasTag("whale")) 
end

--۽
local function dashengon(inst)
	local hunger_percent = inst.components.hunger:GetPercent()
	if hunger_percent < 0.1 then
		inst.components.talker:Say("I must eat something first to open my fire eyes")
		return
	end
	
	inst:AddTag("dasheng")
	inst:RemoveTag("wukong")
	inst.AnimState:SetBuild("wukongH")

	inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE * 5
	inst.components.sanity.dapperness = -TUNING.DAPPERNESS_HUGE
	inst.components.combat.min_attack_period = 0.1

	inst.SoundEmitter:PlaySound("dontstarve_DLC001/common/moggles_on")
	if GetClock() and GetWorld() and GetWorld().components.colourcubemanager then	
		GetClock():SetNightVision(true)
	end
end

local function dashengoff(inst)
	inst:AddTag("wukong")
	inst:RemoveTag("dasheng")
	inst.AnimState:SetBuild("wukong")
	inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE
	inst.components.sanity.dapperness = 0
	inst.components.combat.min_attack_period = 0.5
	


	if  GetClock() then
		GetClock():SetNightVision(false)
	end
	if  GetWorld() and GetWorld().components.colourcubemanager then
		GetWorld().components.colourcubemanager:SetOverrideColourCube(nil, .5)
	end
	inst.SoundEmitter:PlaySound("dontstarve_DLC001/common/moggles_off")

end

local function huoyanjinjing(inst)
	if inst.level >= level_yan and inst.level < level_max then 
		if inst:HasTag("wukong") then 
			dashengon(inst) 
		elseif inst:HasTag("dasheng") then 
			dashengoff(inst)
		end
	end
end

local function onhungerchange(inst)
	local percent = inst.components.hunger:GetPercent()
	if percent < 0.1 and inst:HasTag("dasheng")	 then
		inst.components.talker:Say("I must eat something first to open my fire eyes")
		dashengoff(inst)
	end
end

--ʹý𹿰
local function isholdingjingubang(inst)
	local inventory = inst.components.inventory
	for k,v in pairs(inventory.equipslots) do
        if v.prefab == "ruyibang" then
            return true
        end
    end
end

local function onworked(inst, data)
	local action = data.target.components.workable.action
	if isholdingjingubang(inst) and data.target and data.target.components.workable then
		inst.components.hunger:DoDelta(-5)
	end		
end


--
local function onattackother(inst, data)
	local target = data.target
	if isanimals(target) and not iskillers(target) and inst.level > level_bang then
		local delta = math.ceil(-inst.level * 1.5)
		inst.components.sanity:DoDelta(delta)
	end
	if inst.level == level_max and target:HasTag("monster") and inst:HasTag("dasheng") and not target:HasTag("epic") then
		inst.components.talker:Say("Dou Zhan Sheng Fo")
		inst.components.combat:AddDamageModifier("wukong", 199)
		--inst.components.combat:SetAreaDamage(3)
	elseif inst.level > level_yan and inst:HasTag("dasheng") and math.random() < change_multdam and target:HasTag("monster") then
		inst.components.talker:Say("Yao Guai Shou Si")
		local mult = math.ceil(inst.level * 0.2)
		inst.components.combat:AddDamageModifier("wukong", mult)
	else
		inst.components.combat:AddDamageModifier("wukong", 0)
		--inst.components.combat.areahitrange = nil
	end
end


--
local function applyupgrades(inst)	        
	local upgrades = math.min(inst.level, level_max)
	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil (100 + upgrades * (250 - 100) / level_max)
	inst.components.health.maxhealth = math.ceil (120 + upgrades * (300 - 120) / level_max)
	inst.components.sanity.max = math.ceil (80 + upgrades * (200 - 80) / level_max)
	inst.components.locomotor.walkspeed =  (4 * (1.1 + upgrades * (1.7 - 1.1) / level_max))
	inst.components.locomotor.runspeed = (6 * (1.1 + upgrades * (1.7 - 1.1) / level_max))
	inst.components.sanity.neg_aura_mult = (1 - upgrades / level_max)
	inst.components.sanity.night_drain_mult = (1 - upgrades / level_max)       
	inst.components.talker:Say("Level Up, Lv:".. (inst.level))
         

	
	if inst.level > level_bang then
		local jingubang_recipe = Recipe("ruyibang", {Ingredient("goldnugget", 2),}, RECIPETABS.WAR, {SCIENCE = 0, MAGIC = 1, ANCIENT = 0}, RECIPE_GAME_TYPE.COMMON)
		jingubang_recipe.sortkey = 1
		jingubang_recipe.atlas = "images/inventoryimages/ruyibang.xml"
		jingubang_recipe.image = "ruyibang.tex"
		inst.components.eater.ablefoods = {"VEGGIE", "INSECT", "SEEDS", "GENERIC"}
	end

	if inst.level > level_yan then   
		inst.components.health.fire_damage_scale = 0
	end
		
	if inst.level == level_max then
		inst.components.talker:Say("Dou Zhan Sheng Fo")
		
	end

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
end

--ɱ
local function onkill(inst, data)
	local levelup = false
	if data.cause == inst.prefab
		and not data.inst:HasTag("prey") 
		and not data.inst:HasTag("veggie") 
		and not data.inst:HasTag("structure") then
		if data.inst:HasTag("minotaur") then
			levelup = true
		elseif data.inst:HasTag("epic") and math.random() < chance_boss and not data.inst:HasTag("tentacle") then
		    levelup = true
		elseif (data.inst:HasTag("spiderqueen") or data.inst:HasTag("warg") or data.inst:HasTag("leif")) and math.random() < chance_big then
		    levelup = true
		elseif (data.inst:HasTag("monster") or data.inst:HasTag("werepig") or data.inst:HasTag("tentacle")) and math.random() < chance_normal then
		    levelup = true
		end
	end
	
	if levelup and inst.level < level_max then
        inst.level = inst.level + 1
        applyupgrades(inst) 
        inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
        inst.HUD.controls.status.heart:PulseGreen()
        inst.HUD.controls.status.stomach:PulseGreen()
        inst.HUD.controls.status.brain:PulseGreen()
            
        inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
        inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
		
    end	
end


-- 洢
local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end
end

local function onsave(inst, data)
    data.level = inst.level
end
	

local fn = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "wolfgang"
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "wukong.tex" )
	
	inst:AddTag("wukong")
	inst:AddTag("monkeyking")
	inst.AnimState:SetBuild("wukong")
	-- inst.components.inventory:GuaranteeItems(start_inv)
	inst.level = 0
	applyupgrades(inst)
	

	-- inst.components.sanity.dapperness = TUNING.DAPPERNESS_SMALL
	inst.components.combat.min_attack_period = 0.5
	inst.components.temperature.inherentinsulation = 30
	
	local jindouyun_recipe = Recipe("jindouyun_item", {Ingredient("ice", 5), Ingredient("nightmarefuel", 5),}, RECIPETABS.NAUTICAL, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0}, RECIPE_GAME_TYPE.SHIPWRECKED)
	jindouyun_recipe.sortkey = 1
	jindouyun_recipe.atlas = "images/inventoryimages/jindouyun.xml"
	jindouyun_recipe.image = "jindouyun.tex"
	
	local monkeykingcrown_recipe = Recipe("monkeykingcrown", {Ingredient("goldnugget", 4), Ingredient("feather_robin", 2),}, RECIPETABS.WAR, {SCIENCE = 0, MAGIC = 1, ANCIENT = 0}, RECIPE_GAME_TYPE.COMMON)
	monkeykingcrown_recipe.sortkey = 2
	monkeykingcrown_recipe.atlas = "images/inventoryimages/monkeykingcrown.xml"
	monkeykingcrown_recipe.image = "monkeykingcrown.tex"
	
	inst.OnSave = onsave
    inst.OnPreLoad = onpreload
	
	inst:ListenForEvent("entity_death", function(wrld, data) onkill(inst, data) end, GetWorld())
	
	inst:ListenForEvent("onattackother", onattackother)
	
	inst:ListenForEvent("working", onworked)
	
	inst:ListenForEvent("hungerdelta", onhungerchange)
	
	
	TheInput:AddKeyUpHandler(KEY_R, function()
	if inst.level > level_yan then 
		if inst:HasTag("wukong") then 
			dashengon(inst) 
		elseif inst:HasTag("dasheng") then 
			dashengoff(inst)
		end
	end		
	end)
	
	TheInput:AddKeyUpHandler(KEY_L, function()
	inst.components.talker:Say("Lv:".. (inst.level))
	end)
	
end
return MakePlayerCharacter("wukong", prefabs, assets, fn, start_inv)
