TUNING.RTYSADDLE_BONUS_DAMAGE = 150
TUNING.RTYSADDLE_USES = 10
TUNING.RTYSADDLE_SPEEDMULT = 1.1

TUNING.RTYSADDLE_YELLOW_BONUS_DAMAGE = 100
TUNING.RTYSADDLE_YELLOW_USES = 10
TUNING.RTYSADDLE_YELLOW_SPEEDMULT = 1.5

TUNING.RTYSADDLE_BLUE_BONUS_DAMAGE = 25
TUNING.RTYSADDLE_BLUE_USES = 10
TUNING.RTYSADDLE_BLUE_SPEEDMULT = 2

TUNING.RTYSADDLE_GREEN_BONUS_DAMAGE = 50
TUNING.RTYSADDLE_GREEN_USES = 10
TUNING.RTYSADDLE_GREEN_SPEEDMULT = 1.8


PrefabFiles = {
	"rtysaddle",
    "rtysaddle_blue",
    "rtysaddle_green",
    "rtysaddle_yellow",
    "rtyneichen",
    "rtyneichen_tx",
    "rty2amulet",
}

Assets = {
	Asset("IMAGE", "images/inventoryimages/rtysaddle.tex"),
	Asset("ATLAS", "images/inventoryimages/rtysaddle.xml"),
	Asset("IMAGE", "images/inventoryimages/rtysaddle_blue.tex"),
	Asset("ATLAS", "images/inventoryimages/rtysaddle_blue.xml"),
	Asset("IMAGE", "images/inventoryimages/rtysaddle_green.tex"),
	Asset("ATLAS", "images/inventoryimages/rtysaddle_green.xml"),
	Asset("IMAGE", "images/inventoryimages/rtysaddle_yellow.tex"),
	Asset("ATLAS", "images/inventoryimages/rtysaddle_yellow.xml"),
	Asset("ATLAS", "images/inventoryimages/rtyneichen.xml"),
	Asset( "ATLAS", "images/inventoryimages/rty2amulet.xml" ),
}

local require = GLOBAL.require

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local TECH = GLOBAL.TECH


local rtysaddle = AddRecipe("rtysaddle", {Ingredient("saddle_war", 2), Ingredient("saddle_race", 2), Ingredient("redgem", 10)}, RECIPETABS.TOOLS,  TECH.SCIENCE_TWO,nil,nil,nil,nil,nil,"images/inventoryimages/rtysaddle.xml")
local rtysaddle_yellow = AddRecipe("rtysaddle_yellow", {Ingredient("saddle_war", 2), Ingredient("saddle_race", 2), Ingredient("yellowgem", 5)}, RECIPETABS.TOOLS,  TECH.SCIENCE_TWO,nil,nil,nil,nil,nil,"images/inventoryimages/rtysaddle_yellow.xml")
local rtysaddle_blue = AddRecipe("rtysaddle_blue", {Ingredient("saddle_race", 2), Ingredient("ice", 99), Ingredient("bluegem", 10)}, RECIPETABS.TOOLS,  TECH.SCIENCE_TWO,nil,nil,nil,nil,nil,"images/inventoryimages/rtysaddle_blue.xml")
local rtysaddle_green = AddRecipe("rtysaddle_green", {Ingredient("saddle_war", 2), Ingredient("saddle_race", 2), Ingredient("greengem", 5)}, RECIPETABS.TOOLS,  TECH.SCIENCE_TWO,nil,nil,nil,nil,nil,"images/inventoryimages/rtysaddle_green.xml")
local rtyneichen = AddRecipe("rtyneichen",{Ingredient("eyebrellahat", 1), Ingredient("beargervest", 1), Ingredient("nightmarefuel", 50)},  RECIPETABS.MAGIC, TECH.NONE,nil,nil,nil,nil,nil, "images/inventoryimages/rtyneichen.xml")
local rty2amulet = AddRecipe("rty2amulet",{Ingredient("orangeamulet", 2), Ingredient("yellowamulet", 2), Ingredient("nightmarefuel", 30)},  RECIPETABS.MAGIC, TECH.NONE,nil,nil,nil,nil,nil, "images/inventoryimages/rty2amulet.xml")

GLOBAL.STRINGS.NAMES.RTYSADDLE = "Magma Saddle"
GLOBAL.STRINGS.RECIPE_DESC.RTYSADDLE = "Attack+150,Speed+10%"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.RTYSADDLE = "A very destructive force"

GLOBAL.STRINGS.NAMES.RTYSADDLE_YELLOW = "Sunlight Saddle"
GLOBAL.STRINGS.RECIPE_DESC.RTYSADDLE_YELLOW = "Attack+100,Speed+50%"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.RTYSADDLE_YELLOW = "Balanced power of the Sun"

GLOBAL.STRINGS.NAMES.RTYSADDLE_BLUE = "Arctic Saddle"
GLOBAL.STRINGS.RECIPE_DESC.RTYSADDLE_BLUE = "Attack+25,Speed+100%"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.RTYSADDLE_BLUE = "It seems to make the ground smooth as ice"

GLOBAL.STRINGS.NAMES.RTYSADDLE_GREEN = "Earth Saddle"
GLOBAL.STRINGS.RECIPE_DESC.RTYSADDLE_GREEN = "Attack+50,Speed+80%"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.RTYSADDLE_GREEN = "Mother Nature's blessings are upon us"

GLOBAL.STRINGS.NAMES.RTYNEICHEN = "Death's Cloak"
GLOBAL.STRINGS.RECIPE_DESC.RTYNEICHEN = "Evade the inevitable."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.RTYNEICHEN = "Hide from Death himself.."

GLOBAL.STRINGS.NAMES.RTY2AMULET = "Ancient Amulet"
GLOBAL.STRINGS.RECIPE_DESC.RTY2AMULET = "Harness the true power of darkness.."
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.RTY2AMULET = "I can feel the power surging within.."

TUNING.RTYNEICHEN_ABSORB=0.75
local function SweingPostInit(inst)
	local oldDoSewing = inst.DoSewing
	local function DoSewing(self, target, doer)
		oldDoSewing(self, target, doer)
		if target.prefab == "rtyneichen" then
			----
			target.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_ABSOLUTE)
			target.components.equippable.insulated = true
			target.components.equippable.dapperness = 0
			target.components.equippable.walkspeedmult = 1
			----
			if GLOBAL.TheWorld.state.iswinter then
				target.components.insulator:SetInsulation(TUNING.INSULATION_LARGE) 
				target.components.insulator:SetWinter()
				if target.components.equippable:IsEquipped() then 
					target.tx.AnimState:PlayAnimation("rtyneichen_txh") 
				end
			------
			elseif GLOBAL.TheWorld.state.isspring then
				target.components.insulator:SetInsulation(TUNING.INSULATION_LARGE) 
				target.components.insulator:SetWinter()
				if target.components.equippable:IsEquipped() then 
					target.tx.AnimState:PlayAnimation("rtyneichen_txh") 
				end
				target.components.equippable.dapperness = TUNING.DAPPERNESS_MED_LARGE	
			------
			elseif GLOBAL.TheWorld.state.issummer then
			------
			else
				target.components.insulator:SetInsulation(TUNING.INSULATION_LARGE) 	 
				target.components.insulator:SetSummer() 
				if target.components.equippable:IsEquipped() then 
					target.tx.AnimState:PlayAnimation("rtyneichen_txc") 
				end
				target.components.equippable.walkspeedmult = TUNING.CANE_SPEED_MULT
			end

			if target.components.equippable:IsEquipped() and target.components.inventoryitem.owner:HasTag("player") then
				target.components.fueled:StartConsuming()				
				----
				local player=target.components.inventoryitem.owner
				player.components.health:SetAbsorptionAmount(TUNING.RTYNEICHEN_ABSORB+(1-TUNING.RTYNEICHEN_ABSORB)*target.player_original_absorb)
			--------------------------------------------------
			end
		end		
		return true
	end
	inst.DoSewing = DoSewing
end
AddComponentPostInit("sewing", SweingPostInit) 


