local function autopickup(inst, owner)
     if owner == nil or owner.components.inventory == nil then
        return
    end
    local x, y, z = owner.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x, y, z, TUNING.ORANGEAMULET_RANGE*2, { "_inventoryitem" }, { "INLIMBO", "NOCLICK", "catchable", "fire" })
    for i, v in ipairs(ents) do
        if v.components.inventoryitem ~= nil and
            v.components.inventoryitem.canbepickedup and 
            v.components.inventoryitem.cangoincontainer and
            not v.components.inventoryitem:IsHeld() and owner.components.inventory:CanAcceptCount(v, 1) > 0 and
	    (v.prefab =="cutgrass"	 or v.prefab =="twigs"		or v.prefab =="log"
	    or v.prefab =="cutreeds"	 or v.prefab =="rocks"		or v.prefab =="goldnugget"
	    or v.prefab =="flint"	 or v.prefab =="nitre"		or v.prefab =="charcoal"
	    or v.prefab =="ash"		 or v.prefab =="houndstooth"	or v.prefab =="pigskin"
	    or v.prefab =="manrabbit_tail" or v.prefab =="silk"		or v.prefab =="spidergland"
	    or v.prefab =="moonrocknugget"
	    
	    or v.prefab =="spidereggsack" or v.prefab =="beefalowool"	or v.prefab =="honeycomb"
	    or v.prefab =="stinger"	 or v.prefab =="tentaclespots"	or v.prefab =="livinglog"
	    or v.prefab =="nightmarefuel" or v.prefab =="gears"		or v.prefab =="walrus_tusk"
	    or v.prefab =="redgem"	 or v.prefab =="bluegem"	or v.prefab =="purplegem"
	    or v.prefab =="greengem"	 or v.prefab =="orangegem"	or v.prefab =="yellowgem"
	    or v.prefab =="petals" or v.prefab =="petals_evil" or v.prefab =="pinecone" or v.prefab =="lureplantbulb"

	    or v.prefab =="thulecite"  or v.prefab =="thulecite_pieces" or v.prefab =="feather_crow"
	    or v.prefab =="feather_robin" or v.prefab =="tentaclespots" or v.prefab =="feather_robin_winter"
	    or v.prefab =="butterflywings" or v.prefab =="mosquitosack"		or v.prefab =="deerclops_eyeball"
	    or v.prefab =="lightninggoathorn" or v.prefab =="guano"	or v.prefab =="poop"
	    or v.prefab =="ice"		or v.prefab =="goose_feather"	or v.prefab =="dragon_scales"
	    
	    or v.prefab =="coontail"	or v.prefab =="acorn"	or v.prefab =="seeds"
	    or v.prefab =="carrot_seeds" or v.prefab =="pumpkin_seeds" or v.prefab =="dragonfruit_seeds"
	    or v.prefab =="pomegranate_seeds" or v.prefab =="corn_seeds" or v.prefab =="durian_seeds"
	    or v.prefab =="eggplant_seeds" or v.prefab =="smallmeat"	or v.prefab =="meat"
	    or v.prefab =="drumstick"	or v.prefab =="monstermeat"	or v.prefab =="plantmeat"
	    or v.prefab =="watermelon_seeds"

	    or v.prefab =="bird_egg"	or v.prefab =="rottenegg"	or v.prefab =="tallbirdegg"
	    or v.prefab =="fish"	or v.prefab =="eel"		or v.prefab =="froglegs"
	    or v.prefab =="batwing"	or v.prefab =="honey"		or v.prefab =="butter"
	    or v.prefab =="spoiled_food" or v.prefab =="goatmilk"	or v.prefab =="dug_grass"
	    or v.prefab =="dug_sapling"	or v.prefab =="dug_berrybush"	or v.prefab =="dug_berrybush2"
	    or v.prefab =="carrot"	or v.prefab =="boneshard"	or v.prefab =="furtuft"    

	    or v.prefab =="dug_berrybush_juicy"	 or v.prefab =="dug_marsh_bush"
	    or v.prefab =="cookedsmallmeat"	 or v.prefab =="cookedmeat"		or v.prefab =="drumstick_cooked"
	    or v.prefab =="monstermeat"		 or v.prefab =="plantmeat_cooked"	or v.prefab =="fish_cooked"
	    or v.prefab =="eel_cooked"		 or v.prefab =="froglegs_cooked"	or v.prefab =="batwing_cooked"
	    or v.prefab =="trunk_cooked"	 or v.prefab =="cookedmandrake"		or v.prefab =="bearger_fur"
	    or v.prefab =="beardhair"		 or v.prefab =="cookedmonstermeat"	or v.prefab =="berries_juicy"
	    or v.prefab =="shroom_skin"		 or v.prefab =="royal_jelly"
	    or string.sub(v.prefab,0,5) =="turf_"
	    )    
	    
	    then

            --Amulet will only ever pick up items one at a time. Even from stacks.
            local fx = SpawnPrefab("small_puff")
            fx.Transform:SetPosition(v.Transform:GetWorldPosition())
            fx.Transform:SetScale(.5, .5, .5)

            if v.components.stackable ~= nil then
                v = v.components.stackable:Get()
            end

            if v.components.trap ~= nil and v.components.trap:IsSprung() then
                v.components.trap:Harvest(owner)
            else
                owner.components.inventory:GiveItem(v)
            end
            return
        end
    end
end