local assets =
{
    Asset("ANIM", "anim/rty2amulet.zip"),
    Asset("ANIM", "anim/rty2amulet_swap.zip"),

    
   Asset("ATLAS", "images/inventoryimages/rty2amulet.xml"),
   Asset("IMAGE", "images/inventoryimages/rty2amulet.tex"),
}



local prefabs = 
{
}   

local function autopickup(inst, owner)
     if owner == nil or owner.components.inventory == nil then
        return
    end
    local x, y, z = owner.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x, y, z, 6, { "_inventoryitem" }, { "INLIMBO", "NOCLICK", "catchable", "fire" })
    ----------------------------------------------------
    for i, v in ipairs(ents) do
		if v.components.inventoryitem ~= nil and
			v.components.inventoryitem.canbepickedup and 
			v.components.inventoryitem.cangoincontainer and
			not v.components.inventoryitem:IsHeld() and owner.components.inventory:CanAcceptCount(v, 1) > 0 and
			(v.prefab =="cutgrass"	 or v.prefab =="twigs"		or v.prefab =="log"
			or v.prefab =="cutreeds"	 or v.prefab =="rocks"		or v.prefab =="goldnugget"
			or v.prefab =="flint"	 or v.prefab =="nitre"		or v.prefab =="charcoal"
			or v.prefab =="ash"		 or v.prefab =="houndstooth"	or v.prefab =="pigskin"
			or v.prefab =="manrabbit_tail" or v.prefab =="silk"		or v.prefab =="spidergland"
			or v.prefab =="moonrocknugget"

			or v.prefab =="spidereggsack" or v.prefab =="beefalowool"	or v.prefab =="honeycomb"
			or v.prefab =="stinger"	 or v.prefab =="tentaclespots"	or v.prefab =="livinglog"
			or v.prefab =="nightmarefuel" or v.prefab =="gears"		or v.prefab =="walrus_tusk"
			or v.prefab =="redgem"	 or v.prefab =="bluegem"	or v.prefab =="purplegem"
			or v.prefab =="greengem"	 or v.prefab =="orangegem"	or v.prefab =="yellowgem"
			or v.prefab =="petals" or v.prefab =="petals_evil" or v.prefab =="pinecone" or v.prefab =="lureplantbulb"

			or v.prefab =="thulecite"  or v.prefab =="thulecite_pieces" or v.prefab =="feather_crow"
			or v.prefab =="feather_robin" or v.prefab =="marble" or v.prefab =="feather_robin_winter"
			or v.prefab =="butterflywings" or v.prefab =="green_cap"		or v.prefab =="deerclops_eyeball"
			or v.prefab =="lightninggoathorn" or v.prefab =="blue_cap"	or v.prefab =="poop"
			or v.prefab =="ice"		or v.prefab =="goose_feather"	or v.prefab =="dragon_scales"

			or v.prefab =="red_cap"	or v.prefab =="acorn"	or v.prefab =="seeds"
			or v.prefab =="carrot_seeds" or v.prefab =="pumpkin_seeds" or v.prefab =="dragonfruit_seeds"
			or v.prefab =="pomegranate_seeds" or v.prefab =="corn_seeds" or v.prefab =="durian_seeds"
			or v.prefab =="eggplant_seeds" or v.prefab =="smallmeat"	or v.prefab =="meat"
			or v.prefab =="drumstick"	or v.prefab =="monstermeat"	or v.prefab =="plantmeat"
			or v.prefab =="watermelon_seeds"

			or v.prefab =="bird_egg"	or v.prefab =="rottenegg"	or v.prefab =="tallbirdegg"
			or v.prefab =="fish"	or v.prefab =="eel"		or v.prefab =="froglegs"
			or v.prefab =="batwing"	or v.prefab =="honey"		or v.prefab =="butter"
			or v.prefab =="spoiled_food" or v.prefab =="goatmilk"	or v.prefab =="dug_grass"
			or v.prefab =="dug_sapling"	or v.prefab =="dug_berrybush"	or v.prefab =="dug_berrybush2"
			or v.prefab =="carrot"	or v.prefab =="boneshard"	or v.prefab =="furtuft"    

			or v.prefab =="dug_berrybush_juicy"	 or v.prefab =="dug_marsh_bush"
			or v.prefab =="cookedsmallmeat"	 or v.prefab =="cookedmeat"		or v.prefab =="drumstick_cooked"
			or v.prefab =="monstermeat"		 or v.prefab =="plantmeat_cooked"	or v.prefab =="fish_cooked"
			or v.prefab =="eel_cooked"		 or v.prefab =="froglegs_cooked"	or v.prefab =="batwing_cooked"
			or v.prefab =="trunk_cooked"	 or v.prefab =="cookedmandrake"		or v.prefab =="bearger_fur"
			or v.prefab =="beardhair"		 or v.prefab =="cookedmonstermeat"	or v.prefab =="berries_juicy"
			or v.prefab =="shroom_skin"		 or v.prefab =="royal_jelly"		--or v.prefab =="rtyboomerang"
			or string.sub(v.prefab,0,5) =="turf_"
			)    

			then

			--Amulet will only ever pick up items one at a time. Even from stacks.
			local fx = SpawnPrefab("small_puff")
			fx.Transform:SetPosition(v.Transform:GetWorldPosition())
			fx.Transform:SetScale(.5, .5, .5)

			if v.components.stackable ~= nil then
			v = v.components.stackable:Get()
			end

			if v.components.trap ~= nil and v.components.trap:IsSprung() then
			v.components.trap:Harvest(owner)
			else
			owner.components.inventory:GiveItem(v)
			end
			return
		end
   end
   ----------------------------------------------------
end

local function turnon(inst)
	if inst.components.fueled ~= nil then
		inst.components.fueled:StartConsuming()
	end
	local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
	if inst._light == nil or not inst._light:IsValid() then
		if owner and inst.components.fueled and not inst.components.fueled:IsEmpty() then 
			inst._light = SpawnPrefab("yellowamuletlight")	
			inst._light.entity:SetParent(owner.entity)
		end
	end
end    
local function turnoff(inst)
    if inst._light ~= nil then
        if inst._light:IsValid() then
            inst._light:Remove()
        end
        inst._light = nil
    end
end    

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_body", "rty2amulet", "swap_body")
	
	turnon(inst)

	inst.task = inst:DoPeriodicTask(0.25, autopickup, nil, owner)
end

local function onunequip(inst, owner)
     owner.AnimState:ClearOverrideSymbol("swap_body")
     if inst.task then
	     inst.task:Cancel()
	     inst.task = nil
     end
     
    if inst.components.fueled ~= nil then
        inst.components.fueled:StopConsuming()
    end

    turnoff(inst)
end
local function ontakefuel(inst)
    if inst.components.equippable ~= nil and inst.components.equippable:IsEquipped() then
        turnon(inst)
    end
end
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("rty2amulet")
    inst.AnimState:SetBuild("rty2amulet")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("rty2amulets")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "rty2amulet"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/rty2amulet.xml"  
    inst.components.inventoryitem:SetOnDroppedFn(turnoff)

    inst:AddComponent("equippable")
    ---用来支持多格装备栏
    inst.components.equippable.equipslot =EQUIPSLOTS.NECK or EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip) 
    inst.components.equippable.walkspeedmult = 1.2  

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = FUELTYPE.NIGHTMARE
    inst.components.fueled:InitializeFuelLevel(TUNING.YELLOWAMULET_FUEL*2)
    inst.components.fueled:SetDepletedFn(turnoff)   
    inst.components.fueled:SetTakeFuelFn(ontakefuel)
    inst.components.fueled.accepting = true

    inst._light = nil
    inst.OnRemoveEntity = turnoff

    MakeHauntableLaunch(inst)

    return inst
end

return Prefab("common/inventory/rty2amulet", fn, assets, prefabs)