 local assets = {
        Asset("ANIM", "anim/rtysaddle_blue.zip"),
        Asset("ATLAS", "images/inventoryimages/rtysaddle_blue.xml"),
        Asset("IMAGE", "images/inventoryimages/rtysaddle_blue.tex"),
    }

local function ondiscarded(inst)
    inst.components.finiteuses:Use()
end

local function onusedup(inst)
    SpawnPrefab("ground_chunks_breaking").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst:Remove()
end

local function MakeSaddle(name, data)


    local function fn()
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()

        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("saddlebasic")
        inst.AnimState:SetBuild(name)
        inst.AnimState:PlayAnimation("idle")

        inst.mounted_foleysound = "dontstarve/beefalo/saddle/war_foley"

        inst.entity:SetPristine()

        if not TheWorld.ismastersim then
            return inst
        end

        inst:AddComponent("inspectable")
        inst:AddComponent("inventoryitem")
        inst.components.inventoryitem.atlasname = "images/inventoryimages/rtysaddle_blue.xml"
        inst.components.inventoryitem.imagename = "rtysaddle_blue"
        
        inst:AddComponent("saddler")
        inst.components.saddler:SetBonusDamage(data.bonusdamage)
	inst.components.saddler:SetBonusSpeedMult(data.speedmult)
        inst.components.saddler:SetSwaps(name, "swap_saddle")
        inst.components.saddler:SetDiscardedCallback(ondiscarded)

        inst:AddComponent("finiteuses")
        inst.components.finiteuses:SetMaxUses(data.uses)
        inst.components.finiteuses:SetUses(data.uses)
        inst.components.finiteuses:SetOnFinished(onusedup)

        MakeHauntableLaunch(inst)

        return inst
    end

    return Prefab(name, fn, assets)
end

local data = {
    ty = {
        bonusdamage = 25,
        uses = 10,
        speedmult = 2,
    },
}

return  MakeSaddle("rtysaddle_blue", data.ty)
