
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/willow.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
        Asset( "ANIM", "anim/boxer.zip" ),
        Asset( "ANIM", "anim/ghost_boxer_build.zip" ),
}
local prefabs = {}



local start_inv = {
}

local function onbecamehuman(inst)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


local common_postinit = function(inst) 
	inst.MiniMapEntity:SetIcon( "boxer.tex" )
end


local TAUNTABLETAGS = {
    "monster", 
    "pig", 
    "beefalo",
}

local function ontaunt(inst)
            --print("Taunting!")
            local x,y,z = inst.Transform:GetWorldPosition()
            local ents = TheSim:FindEntities(x,y,z, SpringCombatMod(10), {"_combat"}, {"INLIMBO", "player"}, TAUNTABLETAGS )
            for k,v in pairs(ents) do 
                if not (v.components.health and v.components.health:IsDead()) and (v.components.combat and v.components.combat.target ~= inst) and not(inst.components.sanity and inst.components.sanity:IsSane() and v:HasTag("shadowcreature")) then
                    v.components.combat:SetTarget(inst)
                end
            end
end

local function ondeath(inst)
    inst.components.talker:Say((GetString(inst, "ANNOUNCE_DEATH")))
        if inst.taunt_task ~= nil then
            inst.taunt_task:Cancel()
            inst.taunt_task = nil
        end
end

local function tough(inst)

    if inst.components.health.currenthealth > (100) and inst.components.health.currenthealth <= (200) then
        inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 1.0)
        inst.components.combat.damagemultiplier = 0.7
        if inst.taunt_task == nil then
            inst.taunt_task = inst:DoPeriodicTask(1, ontaunt, nil, 1)
            ontaunt(inst, 0)
        end

    elseif inst.components.health.currenthealth >= (50) and inst.components.health.currenthealth <= (100) then
        inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 1.5)
        inst.components.combat.damagemultiplier = 1.7 
        inst.components.health:StartRegen(3, 10)
        if inst.taunt_task ~= nil then
            inst.taunt_task:Cancel()
            inst.taunt_task = nil
        end
    elseif  inst.components.health.currenthealth >= (0) and inst.components.health.currenthealth < (50) then
        inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 2.50)
        inst.components.combat.damagemultiplier = 1.3
        inst.components.health:StartRegen(5, 10)
    end
end


local function eager(inst)

    if inst.components.hunger.current > (100) and inst.components.hunger.current <= (200) then
        inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 0.80 )
        inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 0.80 )
        inst.components.sanity.neg_aura_mult = 1
        inst.components.sanity.night_drain_mult = 1

        
    elseif inst.components.hunger.current >= (50) and inst.components.hunger.current <= (100) then
        inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.30 )
        inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.30 )
        inst.components.sanity.neg_aura_mult = 0.5
        inst.components.sanity.night_drain_mult = 0.5

    elseif  inst.components.hunger.current >= (0) and inst.components.hunger.current < (50) then
        inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 0.60 )
        inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 0.60 )
        inst.components.sanity.neg_aura_mult = 1.5
        inst.components.sanity.night_drain_mult = 1.5

        end
        
end
       
       local function might(inst)
       
        if inst.components.sanity.current > (100) and inst.components.sanity.current <= (200) then
        inst.components.health.absorb = -0.5    
        inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * -2.00 )

        elseif inst.components.sanity.current >= (50) and inst.components.sanity.current <= (100) then
        inst.components.health.absorb = 0.5    
        inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 0.00 )

        elseif  inst.components.sanity.current >= (0) and inst.components.sanity.current < (50) then
        inst.components.health.absorb = 0       
        inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 2.00 )

        end
            
    end
            
            
local master_postinit = function(inst)
	inst.soundsname = "wilson"
	
	inst.components.health:SetMaxHealth(200)
	inst.components.hunger:SetMax(200)
	inst.components.sanity:SetMax(200)
	
    inst.components.combat.damagemultiplier = 1.0
    inst.components.health.absorb = 0.3
	
    inst.components.locomotor.walkspeed = ( TUNING.WILSON_WALK_SPEED * 1.50 )
    inst.components.locomotor.runspeed = ( TUNING.WILSON_RUN_SPEED * 1.50 )
    inst.components.sanity.neg_aura_mult = 1.0
    inst.components.sanity.night_drain_mult = 1.0
    inst.components.sanity.neg_aura_mult = 1.0
    inst.components.sanity.night_drain_mult = 1.0
	inst.components.hunger.hungerrate = 1.5 * TUNING.WILSON_HUNGER_RATE
	
    inst.OnLoad = onload
    inst.OnNewSpawn = onload


    inst:ListenForEvent("healthdelta", function(inst) tough(inst) end )
    inst:ListenForEvent("hungerdelta", function(inst) eager(inst) end )
    inst:ListenForEvent("sanitydelta", function(inst) might(inst) end )

    tough(inst)
    eager(inst)
    might(inst)

    return inst

end

return MakePlayerCharacter("boxer", prefabs, assets, common_postinit, master_postinit, start_inv)
