local assets =
{
	Asset("ANIM", "anim/coherer_small.zip"),
    Asset("ATLAS", "images/inventoryimages/coherer_small.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("coherer_small")
    inst.AnimState:SetBuild("coherer_small")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
    inst:AddTag("molebait")
    inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
	inst:AddComponent("tradable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "coherer_small"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/coherer_small.xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("coherer_small", fn, assets)