
local assets=
{
	Asset("ANIM", "anim/drop_cz83.zip"),
    Asset("ANIM", "anim/cz83.zip"), 
    Asset("ATLAS", "images/inventoryimages/cz83.xml"),
}

local prefabs = 
{
    "fire_projectile", 
}
local function onfinished(inst)
 local fin = SpawnPrefab("cz830")
  fin.Transform:SetPosition(inst.Transform:GetWorldPosition())
  inst:Remove()
end
local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "cz83", "cz83")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 

	end


local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end
local function onattack(inst)
inst.AnimState:PlayAnimation("fish_pst")
end

local function fn()
local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("drop_cz83")
    inst.AnimState:SetBuild("drop_cz83")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("weapon")
	inst.components.weapon.onattack = onattack

 
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "cz83"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/cz83.xml"
     
    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
		
	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	
    inst.components.weapon:SetDamage(50)
    inst.components.weapon:SetRange(13)
	inst.components.weapon:SetProjectile("fire_projectile")
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(15)
	inst.components.finiteuses:SetUses(15)
	inst.components.finiteuses:SetOnFinished(onfinished)
    return inst
end
return Prefab("cz83", fn, assets)