
local assets=
{
	Asset("ANIM", "anim/drop_feaxe.zip"),
    Asset("ANIM", "anim/feaxe.zip"), 
    Asset("ATLAS", "images/inventoryimages/feaxe.xml"),
}

local prefabs = 
{
    "axe", 
}
local function onfinished(inst)
  inst:Remove()
end
local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "feaxe", "feaxe")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 

	end


local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function fn()
local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("drop_feaxe")
    inst.AnimState:SetBuild("drop_feaxe")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("weapon")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "feaxe"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/feaxe.xml"
     
    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
		
	inst:AddComponent("inspectable")
			
	inst:AddTag("sharp")
 	inst:AddComponent("tool") 
    inst.components.tool:SetAction(ACTIONS.CHOP, 1)
    inst.components.weapon:SetDamage(20)
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(100)
	inst.components.finiteuses:SetUses(100)
	inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 0.5)
	inst.components.finiteuses:SetOnFinished(onfinished)
    return inst
end
return Prefab("feaxe", fn, assets)