
local assets=
{
	Asset("ANIM", "anim/drop_fepickaxe.zip"),
    Asset("ANIM", "anim/fepickaxe.zip"), 
    Asset("ATLAS", "images/inventoryimages/fepickaxe.xml"),
}

local prefabs = 
{
    "pickaxe", 
}
local function onfinished(inst)
  inst:Remove()
end
local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "fepickaxe", "fepickaxe")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 

	end


local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end
local function fn()
local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("drop_fepickaxe")
    inst.AnimState:SetBuild("drop_fepickaxe")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("weapon")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "fepickaxe"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/fepickaxe.xml"
     
    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
		
	inst:AddComponent("inspectable")
			
	inst:AddTag("sharp")
 	inst:AddComponent("tool") 
    inst.components.tool:SetAction(ACTIONS.MINE, 1)
    inst.components.weapon:SetDamage(20)
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(100)
	inst.components.finiteuses:SetUses(100)
	inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 1)
	inst.components.finiteuses:SetOnFinished(onfinished)
    return inst
end
return Prefab("fepickaxe", fn, assets)