local assets=
{
    Asset("ANIM", "anim/excalsword.zip"),
    Asset("ANIM", "anim/swap_excalsword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/lightsword.xml"),
    Asset("IMAGE", "images/inventoryimages/lightsword.tex"),
}


local isDropped,isWeared
local function saniup(inst)
	if inst.isWeared 
	then
		inst.components.equippable.dapperness = -0.1
	end
end
local function OnEquip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_excalsword", "swap_excalsword")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
    inst.isWeared = true
	inst.isDropped = false
	owner.Light:Enable(true)
	saniup(inst)
end

  
local function OnUnequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
	owner.Light:Enable(false)
	inst.isWeared = false
	inst.isDropped = false
	saniup(inst)
end

local function ondrop(inst, dropper)
		inst.onuse = false
		inst.Light:Enable(true)
		inst.isDropped = true
	    inst.isWeared = false
	    saniup(inst)
end

local function onpickup(inst, picker)
		inst.onuse = false
		inst.Light:Enable(false)
end
 
local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("excalsword")
    inst.AnimState:SetBuild("excalsword")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")

    local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "lightsword.tex" )
	
	local CRITCHANCE = 0.20

local function onattack(weapon, attacker, target)
	  local health = target.components.health
	--local attacker = inst.components.inventoryitem.owner
      if math.random() < CRITCHANCE then
	  			health:DoDelta(-26)
	  	weapon.components.talker:Say("Crit")
		end
end
	
    local light = inst.entity:AddLight()
	light:SetColour(51/255, 255/255, 255/255)
	light:SetIntensity(0.8)
	light:SetRadius(2.2)
	light:SetFalloff(.33)
	inst.Light:Enable(false)
	
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)
	inst.components.weapon:SetRange(2, 2)
	
	inst:AddComponent("tool") 
    inst.components.tool:SetAction(ACTIONS.CHOP, 0.5)

  
    inst:AddComponent("inspectable")
    inst:AddComponent("talker")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "lightsword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lightsword.xml"
	
	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.inventoryitem.keepondeath = true
	inst.components.inventoryitem.onputininventoryfn = function(inst, player)
		--If it's in their inventory
		local owner = inst.components.inventoryitem:GetGrandOwner()
		if player.components.inventory and player.prefab ~= "esctemplate" then 
			inst:DoTaskInTime(0.1, function()
			
			player.components.inventory:DropItem(inst)
			inst.components.talker:Say("我不是AST成员")
			end)
		--If it's in a container		
		elseif player.components.container and owner.prefab ~= "esctemplate" then 
			inst:DoTaskInTime(0.1, function()
			
			player.components.container:DropItem(inst)
			inst.components.talker:Say("我塞不进包里")
			end)
		end
	end
	
    return inst
end
return  Prefab("lightsword", fn, assets) 