local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/maxwell.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
    Asset("ANIM", "anim/player_woodie.zip"),
    Asset("ANIM", "anim/player_wolfgang.zip"),
		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/writhe.zip" ),
        Asset( "ANIM", "anim/writhe_tool1.zip" ),
        Asset( "ANIM", "anim/writhe_tool2.zip" ),
        Asset( "ANIM", "anim/writhe_tool3.zip" ),
        Asset( "ANIM", "anim/writhe_tool4.zip" ),
        Asset( "ANIM", "anim/writhe_toolf.zip" ),
        Asset( "ANIM", "anim/writhe_toolh.zip" ),
        Asset( "ANIM", "anim/writhe_toolb.zip" ),
}
local prefabs = 
{
}

local start_inv = 
{
	"daddiesvest",
	"writhesack",
}	


local function SetHUDState(inst)
	if inst.HUD then
		    inst.HUD.writheOL = inst.HUD.under_root:AddChild(Image("images/writhevision.xml", "writhevision.tex"))
		    inst.HUD.writheOL:SetVRegPoint(ANCHOR_MIDDLE)
		    inst.HUD.writheOL:SetHRegPoint(ANCHOR_MIDDLE)
		    inst.HUD.writheOL:SetVAnchor(ANCHOR_MIDDLE)
		    inst.HUD.writheOL:SetHAnchor(ANCHOR_MIDDLE)
		    inst.HUD.writheOL:SetScaleMode(SCALEMODE_FILLSCREEN)
		    inst.HUD.writheOL:SetClickable(false)
	end
end

local function drop(inst)

local hand = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
	if hand then
if not hand:HasTag("nikmikwrithe") then
inst:DoTaskInTime(0.1, function()
local item = inst.components.inventory:Unequip(EQUIPSLOTS.HANDS)
inst.components.inventory:GiveItem(item)
    inst.AnimState:OverrideSymbol("swap_object", "nil", "nil")
		end)
		end
	end
end

local fn = function(inst)


	--speech sound and map icon
	inst.soundsname = "winnie"
    inst.MiniMapEntity:SetIcon("writhe.tex")

        local shadow = inst.entity:AddDynamicShadow()
shadow:SetSize( 0, 0 )

	--Stats 
	    inst:AddTag("nikmikwrithe")
	    inst:AddTag("hostile")
        inst.components.health:SetMaxHealth(120)
	inst.components.hunger:SetMax(180)
	inst.components.sanity:SetMax(1)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.3)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.3)	
    inst.components.sanity.neg_aura_mult = 0
	inst.components.sanity.dapperness = -TUNING.DAPPERNESS_TINY

	inst.components.combat:SetDefaultDamage(10)
    inst.components.combat:SetAttackPeriod(0.7)

	inst.components.eater:SetCarnivore()

        inst.AnimState:SetMultColour(1, 1, 1, 0.7)

			inst.talksoundoverride = "dontstarve/sanity/shadowhand_creep"

    inst.components.sanity.night_drain_mult = 0.25

	inst.components.eater.monsterimmune = true
	inst.components.eater.strongstomach = true

if IsDLCEnabled(REIGN_OF_GIANTS) then
	inst:SetStateGraph("SGwrithedlc")
        local writhetool_hrecipe = Recipe( ("writhetool_h"), { Ingredient("log", 3), Ingredient("rope", 2)}, RECIPETABS.TOOLS,  {SCIENCE = 1})
      writhetool_hrecipe.atlas = "images/inventoryimages/writhetool_h.xml"
		else
	inst:SetStateGraph("SGwrithe")
	end

    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(55/255, 50/255, 55/255)

	inst:ListenForEvent("equip", drop)

	inst:DoTaskInTime(0, function() SetHUDState(inst) end)

        local writhetool_1recipe = Recipe( ("writhetool_1"), { Ingredient("flint", 4), Ingredient("cutgrass", 3), Ingredient("twigs", 1)}, RECIPETABS.TOOLS,  {SCIENCE = 0})
      writhetool_1recipe.atlas = "images/inventoryimages/writhetool_1.xml"

        local writhetool_2recipe = Recipe( ("writhetool_2"), { Ingredient("axe", 1), Ingredient("pickaxe", 1), Ingredient("silk", 4)}, RECIPETABS.TOOLS,  {SCIENCE = 1})
      writhetool_2recipe.atlas = "images/inventoryimages/writhetool_2.xml"

        local writhetool_3recipe = Recipe( ("writhetool_3"), { Ingredient("goldenaxe", 1), Ingredient("goldenpickaxe", 1), Ingredient("rope", 4)}, RECIPETABS.TOOLS,  {SCIENCE = 2})
      writhetool_3recipe.atlas = "images/inventoryimages/writhetool_3.xml"

        local writhetool_4recipe = Recipe( ("writhetool_4"), { Ingredient("thulecite", 9), Ingredient("marble", 6), Ingredient("diviningrod", 1)}, RECIPETABS.ANCIENT,  {ANCIENT = 2})
      writhetool_4recipe.atlas = "images/inventoryimages/writhetool_4.xml"

        local writhetool_frecipe = Recipe( ("writhetool_f"), { Ingredient("charcoal", 3), Ingredient("rocks", 3), Ingredient("flint", 2)}, RECIPETABS.LIGHT,  {SCIENCE = 1})
      writhetool_frecipe.atlas = "images/inventoryimages/writhetool_f.xml"

        local writhetool_brecipe = Recipe( ("writhetool_b"), { Ingredient("papyrus", 2), Ingredient("twigs", 3), Ingredient("slurtleslime", 2)}, RECIPETABS.TOOLS,  {SCIENCE = 1})
      writhetool_brecipe.atlas = "images/inventoryimages/writhetool_b.xml"


	    return inst
	
end

STRINGS.CHARACTER_TITLES.writhe = "ʧ "
STRINGS.CHARACTER_NAMES.writhe = " ; "
STRINGS.CHARACTER_DESCRIPTIONS.writhe = "*     ۣ    װ    \n* ١          \n*    "
STRINGS.CHARACTER_QUOTES.writhe = "\"         \""
STRINGS.CHARACTERS.WRITHE = require "speech_writhe"

-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
return MakePlayerCharacter("writhe", prefabs, assets, fn , start_inv)