local assets=
{
        Asset( "ANIM", "anim/writhe_tools.zip" ),
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner) 
    owner.AnimState:SetBuild("writhe_tool1")
end

local function onequip2(inst, owner) 
    owner.AnimState:SetBuild("writhe_tool2")
end

local function onequip3(inst, owner) 
    owner.AnimState:SetBuild("writhe_tool3")
end

local function onequip4(inst, owner) 
    owner.AnimState:SetBuild("writhe_tool4")
end

local function onunequip(inst, owner) 
    owner.AnimState:SetBuild("writhe")
	owner.components.combat:SetDefaultDamage(10)
end

local function onunequip4(inst, owner) 
	owner.components.combat:SetDefaultDamage(10)
    owner.AnimState:SetBuild("writhe")
    if inst.task then
        inst.task:Cancel()
        inst.task = nil
    end
    if inst.effect and inst.effect:IsValid() then
	    inst.effect:Remove()
        inst.effect = nil
    end
    inst.closeness = nil
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.Transform:SetScale(1, 1, 1)

    inst:AddTag("writhetool")

    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("writhe")

		inst.AnimState:SetBank("turf")
		inst.AnimState:SetBuild("writhe_tools")

    return inst
end

local function tool1(Sim)
	local inst = fn(Sim)
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

		inst.AnimState:PlayAnimation("woodfloor")
    
    inst:AddTag("sharp")
    inst:AddTag("nikmikwrithe")
    
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 0.30)
    inst.components.tool:SetAction(ACTIONS.MINE, 0.20)
    -------
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(300)
    inst.components.finiteuses:SetUses(300)
    inst.components.finiteuses:SetOnFinished( onfinished)
    inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 1)

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")   
    inst.components.inventoryitem.atlasname = "images/inventoryimages/writhetool_1.xml"    

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
	return inst
end

local function tool2(Sim)
	local inst = fn(Sim)
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

		inst.AnimState:PlayAnimation("carpet")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(14)
    inst.components.weapon.attackwear = 0.5

    inst:AddTag("sharp")
    inst:AddTag("nikmikwrithe")
    
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 0.40)
    inst.components.tool:SetAction(ACTIONS.MINE, 0.30)
    inst.components.tool:SetAction(ACTIONS.DIG)
    -------

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(500)
    inst.components.finiteuses:SetUses(500)
    inst.components.finiteuses:SetOnFinished( onfinished)
    inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.DIG, 1)

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")   
    inst.components.inventoryitem.atlasname = "images/inventoryimages/writhetool_2.xml"    

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip2 )
    inst.components.equippable:SetOnUnequip( onunequip )
    
	return inst
end

local function tool3(Sim)
	local inst = fn(Sim)
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

		inst.AnimState:PlayAnimation("checker")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(16)
    inst.components.weapon.attackwear = 0.5

    inst:AddTag("sharp")
    inst:AddTag("nikmikwrithe")
    
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 0.60)
    inst.components.tool:SetAction(ACTIONS.MINE, 0.50)
    inst.components.tool:SetAction(ACTIONS.HAMMER, 0.40)
    inst.components.tool:SetAction(ACTIONS.DIG)
    -----

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(600)
    inst.components.finiteuses:SetUses(600)
    inst.components.finiteuses:SetOnFinished( onfinished)
    inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.DIG, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.HAMMER, 1)

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")   
    inst.components.inventoryitem.atlasname = "images/inventoryimages/writhetool_3.xml"    

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip3 )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    if IsDLCEnabled(REIGN_OF_GIANTS) then
    inst.components.equippable.dapperness = TUNING.DAPPERNESS_TINY
	else
    inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = TUNING.DAPPERNESS_TINY
 end

	return inst
end

local prefabs =
{
    "dr_hot_loop",
    "dr_warmer_loop",
    "dr_warm_loop_2",
    "dr_warm_loop_1",
}

local EFFECTS = 
{
    hot = "dr_hot_loop",--{anim="hot_loop", tint=Vector3(181/255, 32/255, 32/255)},
    warmer = "dr_warmer_loop",--{anim="warmer_loop", tint=Vector3(255/255, 163/255, 26/255)},
    warm = "dr_warm_loop_2",--{anim="warm_loop", tint=Vector3(105/255, 182/255, 239/255)},
    cold = "dr_warm_loop_1",--{anim="warm_loop", tint=Vector3(105/255, 160/255, 255/255)},
}

local function FindClosestPart(inst)

    if inst.tracking_parts == nil then
        inst.tracking_parts = {}
        for k,v in pairs(Ents) do
            if v:HasTag("teleportato") or v:HasTag("teleportato_part") or v.prefab == "adventure_portal" then
                table.insert(inst.tracking_parts, v)
            end
        end
    end

    if inst.tracking_parts then
        local closest = nil
        local closest_dist = nil
        for k,v in pairs(inst.tracking_parts) do
            if v:IsValid() and not v:IsInLimbo() then
                local dist = v:GetDistanceSqToInst(inst)
                if not closest_dist or dist < closest_dist then
                    closest = v
                    closest_dist = dist
                end
            end
        end

        return closest
    end

end

local function CheckTargetPiece(inst)
    if inst.components.equippable:IsEquipped() and inst.components.inventoryitem.owner then
        local intensity = 0
        local closeness = nil
        local fx = nil
        local target = FindClosestPart(inst) --FindEntity(inst, TUNING.DIVINING_MAXDIST, function(guy) return (guy:HasTag("teleportato") or guy:HasTag("teleportato_part") ) and not guy:IsInLimbo() end)
        local nextpingtime = TUNING.DIVINING_DEFAULTPING
        if target then
            local distsq = inst.components.inventoryitem.owner:GetDistanceSqToInst(target)
            intensity = math.max(0, 1 - (distsq/(TUNING.DIVINING_MAXDIST*TUNING.DIVINING_MAXDIST) ))
            for k,v in ipairs(TUNING.DIVINING_DISTANCES) do
                closeness = v
                fx = EFFECTS[v.describe]

                if v.maxdist and distsq <= v.maxdist*v.maxdist then
                    nextpingtime = closeness.pingtime
                    break
                end
            end
        end

        if closeness ~= inst.closeness then
            inst.closeness = closeness
	        local desc = inst.components.inspectable:GetDescription(inst.components.inventoryitem.owner)
	        if desc then
	            inst.components.inventoryitem.owner.components.talker:Say(desc)
	        end
        end
        
        if fx then
            inst.effect = SpawnPrefab(fx)--PlayFX(Vector3(0,0,0), "diviningrod_fx", "diviningrod_fx", fx.anim, nil, nil, fx.tint or Vector3(1, 1, 1) )
            local follower = inst.effect.entity:AddFollower()
	        follower:FollowSymbol(inst.components.inventoryitem.owner.GUID, "torso", 0, -280, 1 )
	    end

        inst.SoundEmitter:PlaySound("dontstarve/common/diviningrod_ping", "ping")
        inst.SoundEmitter:SetParameter("ping", "intensity", intensity)
        inst.task = inst:DoTaskInTime(nextpingtime or 1, CheckTargetPiece)
    end 
end

local function describe(inst)
    if inst.components.equippable:IsEquipped() then
        if inst.closeness and inst.closeness.describe then
            return string.upper(inst.closeness.describe)
        end
        return "COLD"
    end
end

local function onuse(inst)
	if not inst.task then
        inst.closeness = nil 
        inst.tracking_parts = nil       
        inst.task = inst:DoTaskInTime(1, CheckTargetPiece)
		else 
    if inst.task then
        inst.task:Cancel()
        inst.task = nil
    			end
    if inst.effect and inst.effect:IsValid() then
	    inst.effect:Remove()
        inst.effect = nil
    		end
    inst.closeness = nil
	end
	inst.components.useableitem:StopUsingItem()
        inst.SoundEmitter:PlaySound("dontstarve/common/teleportato/teleportato_activate_mouth")
end

local function tool4(Sim)
	local inst = fn(Sim)
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter() 
    MakeInventoryPhysics(inst)

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(18)
    inst.components.weapon.attackwear = 0.5

		inst.AnimState:PlayAnimation("road")
    
    inst:AddTag("sharp")
    inst:AddTag("nikmikwrithe")
    
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 0.80)
    inst.components.tool:SetAction(ACTIONS.MINE, 0.70)
    inst.components.tool:SetAction(ACTIONS.HAMMER, 0.70)
    inst.components.tool:SetAction(ACTIONS.DIG)
    -----

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(700)
    inst.components.finiteuses:SetUses(700)
    inst.components.finiteuses:SetOnFinished( onfinished)
    inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.DIG, 1)
    inst.components.finiteuses:SetConsumption(ACTIONS.HAMMER, 1)

    inst:AddComponent("useableitem")
    inst.components.useableitem:SetOnUseFn(onuse)
    
    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = describe

    inst:AddComponent("inventoryitem")   
    inst.components.inventoryitem.atlasname = "images/inventoryimages/writhetool_4.xml"    

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip4 )
    inst.components.equippable:SetOnUnequip( onunequip4 )
    
    if IsDLCEnabled(REIGN_OF_GIANTS) then
    inst.components.equippable.dapperness = TUNING.DAPPERNESS_TINY*1.3
	else
    inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = TUNING.DAPPERNESS_TINY*1.3
 end

	return inst
end

return Prefab( "common/inventory/writhetool_1", tool1, assets),
	Prefab( "common/inventory/writhetool_2", tool2, assets),
	Prefab( "common/inventory/writhetool_3", tool3, assets),
	Prefab( "common/inventory/writhetool_4", tool4, assets)