local assets=
{
        Asset( "ANIM", "anim/writhe_tools.zip" ),
}

local function onfinished(inst)
    inst:Remove()
end

local function onequiph(inst, owner) 
    owner.AnimState:SetBuild("writhe_toolh")
end

local function onequipb(inst, owner) 
    owner.AnimState:SetBuild("writhe_toolb")
	owner.components.combat:SetDefaultDamage(6)
end

local function onunequip(inst, owner) 
    owner.AnimState:SetBuild("writhe")
	owner.components.combat:SetDefaultDamage(10)
end

local function onequipf(inst, owner) 
    owner.AnimState:SetBuild("writhe_toolf")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
        owner:AddTag("writhefire")
    inst.SoundEmitter:PlaySound("dontstarve/wilson/torch_LP", "torch")
    inst.SoundEmitter:PlaySound("dontstarve/wilson/torch_swing")
    inst.SoundEmitter:SetParameter( "torch", "intensity", 1 )

    inst.fire = SpawnPrefab( "torchfire" )
    local follower = inst.fire.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -20, -0.01 )
        inst.components.fueled:StartConsuming()
end

local function onunequipf(inst, owner) 
    owner.AnimState:SetBuild("writhe")
	inst.fire:Remove()
    inst.fire = nil
            owner:RemoveTag("writhefire")
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
    inst.SoundEmitter:KillSound("torch")
    inst.SoundEmitter:PlaySound("dontstarve/common/fireOut")   
    inst.components.fueled:StopConsuming()
end

local function onburnout(inst) 
inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.Transform:SetScale(1, 1, 1)

    inst:AddTag("writhetool")
    inst:AddTag("hammer")

    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("writhe")

		inst.AnimState:SetBank("turf")
		inst.AnimState:SetBuild("writhe_tools")

    return inst
end


local function onattack_fire(inst, attacker, target)

    if target.components.burnable and not target.components.burnable:IsBurning() then
        if target.components.freezable and target.components.freezable:IsFrozen() then           
            target.components.freezable:Unfreeze()            
        else            
            target.components.burnable:Ignite(true)
        end   
    end

    if target.components.freezable then
        target.components.freezable:AddColdness(-1) --Does this break ice staff?
        if target.components.freezable:IsFrozen() then
            target.components.freezable:Unfreeze()            
        end
    end

    if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end

    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
        if target.sg and target.sg.sg.states.hit then
            target.sg:GoToState("hit")
        end
    end
	        inst.components.fueled:DoDelta(-60)
    attacker.SoundEmitter:PlaySound("dontstarve/wilson/fireball_explo")
end

local function onlight(inst, target)
        inst.components.fueled:DoDelta(-3)
end

local function toolf(Sim)
	local inst = fn(Sim)
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    inst.entity:AddSoundEmitter() 

		inst.AnimState:PlayAnimation("rocky")
    
    inst:AddTag("nikmikwrithefire")
    inst:AddTag("nikmikwrithe")
    inst:AddTag("rangedfireweapon")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetOnAttack(onattack_fire)
    inst.components.weapon:SetProjectile("fire_projectile")

    inst:AddComponent("lighter")
    inst.components.lighter:SetOnLightFn(onlight)

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")   
    inst.components.inventoryitem.atlasname = "images/inventoryimages/writhetool_f.xml"    

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequipf )
    inst.components.equippable:SetOnUnequip( onunequipf )
    
    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "WRITHEFUEL"
    inst.components.fueled:InitializeFuelLevel(180)
    inst.components.fueled:SetDepletedFn(onburnout)

	return inst
end

local function toolh(Sim)
	local inst = fn(Sim)
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter() 
    MakeInventoryPhysics(inst)

		inst.AnimState:PlayAnimation("savanna")
    
    inst:AddTag("hammer")
    inst:AddTag("nikmikwrithe")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(12)

    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.HAMMER, 0.30)
    -----

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(80)
    inst.components.finiteuses:SetUses(80)
    inst.components.finiteuses:SetConsumption(ACTIONS.HAMMER, 1)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequiph )
    inst.components.equippable:SetOnUnequip( onunequip )


    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")   
    inst.components.inventoryitem.atlasname = "images/inventoryimages/writhetool_h.xml"    


	return inst
end

local function toolb(Sim)
	local inst = fn(Sim)
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter() 
    MakeInventoryPhysics(inst)

		inst.AnimState:PlayAnimation("marsh")
    
    inst:AddTag("bugnet")
    inst:AddTag("nikmikwrithe")
    
    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.NET)
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(12)
    inst.components.finiteuses:SetUses(12)
    inst.components.finiteuses:SetOnFinished( onfinished)
    
    inst.components.finiteuses:SetConsumption(ACTIONS.NET, 1)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequipb )
    inst.components.equippable:SetOnUnequip( onunequip )


    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")   
    inst.components.inventoryitem.atlasname = "images/inventoryimages/writhetool_b.xml"    


	return inst
end

return Prefab( "common/inventory/writhetool_f", toolf, assets),
	Prefab( "common/inventory/writhetool_h", toolh, assets),
	Prefab( "common/inventory/writhetool_b", toolb, assets)
