local assets=
{
	Asset("ANIM", "anim/armor_daddiesvest.zip"),
 Asset("IMAGE", "images/inventoryimages/daddiesvest.tex"),
 Asset("ATLAS", "images/inventoryimages/daddiesvest.xml"),
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "armor_daddiesvest", "swap_body")
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
end

local function onperish(inst)
	inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("torso_bearger")
    inst.AnimState:SetBuild("armor_daddiesvest")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/trunksuit"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/daddiesvest.xml"

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    if IsDLCEnabled(REIGN_OF_GIANTS) then
    inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL*1.3
	else
    inst:AddComponent("dapperness")
    inst.components.dapperness.dapperness = TUNING.DAPPERNESS_SMALL*1.3
 end
    
	inst:AddComponent("insulator")
    inst.components.insulator.insulation = TUNING.INSULATION_SMALL*1.6
    
    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("writhe")    

    return inst
end

return Prefab( "common/inventory/daddiesvest", fn, assets) 
