local assets=
{
	Asset("ANIM", "anim/writhesack.zip"),
}

SetSharedLootTable( 'sack',
{
    {'writhedivinehat', 1.0},
    {'charcoal',     1.0},
    {'charcoal',     1.0},
    {'charcoal',     1.0},
    {'meat',     1.0},
    {'meat',     1.0},
})

local function GetVerb(inst)
	return "WRITHESACK"
end

local function OnOpen(inst, doer)
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('sack')
doer.components.talker:Say("ǲǺȶ")
            inst.components.lootdropper:DropLoot(Vector3(doer.Transform:GetWorldPosition())) 
		SpawnPrefab("sparklefx").Transform:SetPosition(inst:GetPosition():Get())
        inst.AnimState:PlayAnimation("picked") 
    inst:ListenForEvent("animover", function(inst) inst:Remove() end)
end

local function fn(Sim)
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBuild("writhesack")
    inst.AnimState:SetBank("cactus")
    inst.AnimState:PlayAnimation("idle", true)
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/writhesack.xml"
    inst.components.inventoryitem.cangoincontainer = false

    inst:AddComponent("activatable")
    inst.components.activatable.OnActivate = OnOpen
    inst.components.activatable.inactive = true
    inst.components.activatable.getverb = GetVerb
    inst.components.activatable.quickaction = false
    
    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("writhe")    

		inst:DoTaskInTime(0, function()
		if inst.components.inventoryitem then
		inst:RemoveComponent("inventoryitem")
	end
end)


    return inst
end

return Prefab( "common/inventory/writhesack", fn, assets) 
