local STRINGS = GLOBAL.STRINGS
local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
GetPlayer = GLOBAL.GetPlayer
STRINGS = GLOBAL.STRINGS
RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
Ingredient = GLOBAL.Ingredient
TECH = GLOBAL.TECH


-- Prefab Files
PrefabFiles = {
	"emilyvolviing",
	"emmafire",
	"emmafire_light",
	"emmatuning",
	"sarahsmall",
}

-- Asset Files
Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/emilyvolviing.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/emilyvolviing.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/emilyvolviing.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/emilyvolviing.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/emilyvolviing_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/emilyvolviing_silho.xml" ),

    Asset( "IMAGE", "bigportraits/emilyvolviing.tex" ),
    Asset( "ATLAS", "bigportraits/emilyvolviing.xml" ),
	
	Asset( "IMAGE", "images/map_icons/emilyvolviing.tex" ),
	Asset( "ATLAS", "images/map_icons/emilyvolviing.xml" ),
	
	Asset("ATLAS", "images/inventoryimages/emmafire.xml"),
    Asset("IMAGE", "images/inventoryimages/emmafire.tex"),
	
	Asset( "IMAGE", "images/map_icons/sarahsmall.tex" ),
	Asset( "ATLAS", "images/map_icons/sarahsmall.xml" ),
	
	Asset("ATLAS", "images/inventoryimages/sarahsmall.xml"),
    Asset("IMAGE", "images/inventoryimages/sarahsmall.tex"),
}

-- Custom Maxwell Intro
local function EmmaMaxwellIntro(inst)
    if GLOBAL.GetPlayer().prefab == "emilyvolviing" then
        inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
			appearsound = "dontstarve/maxwell/appear_adventure",
			voice = "dontstarve/maxwell/talk_LP_world1",
			appearanim = "appear2",
			idleanim= "idle2_loop",
			dialogpreanim = "dialog2_pre",
			dialoganim="dialog2_loop",
			dialogpostanim = "dialog2_pst",
			disappearanim = "disappear2",
			disableplayer = true,
            skippable = false,
            {
                string = "Why. Hello my Darling.",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "Let's play a game of survival.",  
                wait = 3,
                anim = nil,
                sound = nil,
            },
			{
                string = "If you fail, I'll send you back to Wruzz and Sarah",  
                wait = 4,
                anim = nil,
                sound = nil,
            },
			{
                string = "Have fun!",  
                wait = 2,
                anim = nil,
                sound = nil,
            },
        }
    end
end

AddPrefabPostInit("maxwellintro", EmmaMaxwellIntro)
  
-- The character select screen lines
GLOBAL.STRINGS.CHARACTER_TITLES.emilyvolviing = "Emily Vol-Viing & Sarah Vol-Viing"
GLOBAL.STRINGS.CHARACTER_NAMES.emilyvolviing = "Emily Vol-Viing"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.emilyvolviing = "*Immune to Anything Hot\n*Gains Sanity when near fire\n*Meat Lover"
GLOBAL.STRINGS.CHARACTER_QUOTES.emilyvolviing = "A Small Cuddly Dragon, With Some Help From Her Sister"

-- Custom Speech
local STRINGS = GLOBAL.STRINGS
GLOBAL.STRINGS.CHARACTERS.EMILYVOLVIING = {}
GLOBAL.STRINGS.CHARACTERS.EMILYVOLVIING.DESCRIBE = {}
GLOBAL.STRINGS.CHARACTERS.EMILYVOLVIING = require "speech_EMILYVOLVIING"
GLOBAL.STRINGS.CHARACTERS.SARAHSMALL = {}
GLOBAL.STRINGS.CHARACTERS.SARAHSMALL.DESCRIBE = {}
GLOBAL.STRINGS.CHARACTERS.SARAHSMALL = require "speech_EMILYVOLVIING"

-- Emily's Torch
GLOBAL.STRINGS.NAMES.EMMAFIRE = "Emily's Fire"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.EMMAFIRE = "A Magical Torch made from Gold and my own Fire."
STRINGS.RECIPE_DESC.EMMAFIRE = "Never Goes Out!\n Infused with My Own Fire."

-- Sarah's Summon Stone
GLOBAL.STRINGS.NAMES.SARAHSMALL = "Sarah Vol-Viing"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SARAHSMALL = "How you doing lil sis?"
STRINGS.RECIPE_DESC.SARAHSMALL = "Summons My Little Sister.\n She Helps Me Do Things."

function emilyvolviingPostInit(emilyvolviing)

	local emmafire = Recipe("emmafire", {Ingredient("goldnugget", 2),Ingredient("twigs", 2)}, RECIPETABS.LIGHT, TECH.NONE)
	emmafire.atlas = "images/inventoryimages/emmafire.xml"
	
	local sarahsmall = Recipe("sarahsmall", {Ingredient("goldnugget", 2),Ingredient("rocks", 2),Ingredient("charcoal", 2)}, RECIPETABS.MAGIC, TECH.NONE)
	sarahsmall.atlas = "images/inventoryimages/sarahsmall.xml"
	
end
	
AddSimPostInit(function(inst)
        if inst.prefab == "emilyvolviing" then
                emilyvolviingPostInit(inst)
        end
end)	

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "emilyvolviing")
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "sarahsmall")

AddMinimapAtlas("images/map_icons/emilyvolviing.xml")
AddModCharacter("emilyvolviing")