local MakePlayerCharacter = require "prefabs/player_common"

local fontsize = 23

local assets = 
{

	Asset( "ANIM", "anim/player_basic.zip" ),
	Asset( "ANIM", "anim/player_idles_shiver.zip" ),
	Asset( "ANIM", "anim/player_actions.zip" ),
	Asset( "ANIM", "anim/player_actions_axe.zip" ),
	Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
	Asset( "ANIM", "anim/player_actions_shovel.zip" ),
	Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
	Asset( "ANIM", "anim/player_actions_eat.zip" ),
	Asset( "ANIM", "anim/player_actions_item.zip" ),
	Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
	Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
	Asset( "ANIM", "anim/player_actions_fishing.zip" ),
	Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
	Asset( "ANIM", "anim/player_bush_hat.zip" ),
	Asset( "ANIM", "anim/player_attacks.zip" ),
	Asset( "ANIM", "anim/player_idles.zip" ),
	Asset( "ANIM", "anim/player_rebirth.zip" ),
	Asset( "ANIM", "anim/player_jump.zip" ),
	Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
	Asset( "ANIM", "anim/player_teleport.zip" ),
	Asset( "ANIM", "anim/wilson_fx.zip" ),
	Asset( "ANIM", "anim/player_one_man_band.zip" ),
	Asset( "ANIM", "anim/shadow_hands.zip" ),
	Asset( "ANIM", "anim/torch.zip"),
	Asset( "ANIM", "anim/swap_torch.zip"),
	Asset( "SOUND", "sound/sfx.fsb" ),
	Asset( "SOUND", "sound/willow.fsb" ),
		
	Asset( "ANIM", "anim/emilyvolviing.zip" ),
}

local prefabs = {
	"emmatuning"
}
local start_inv = 
{
	-- Custom starting items
	"goldnugget",
	"goldnugget",
}

local function onsave(inst, data)
    inst.components.talker:Say("Saving...")
end

-- Sanity
local function sanityfn(inst)
	local x,y,z = inst.Transform:GetWorldPosition()	
	local delta = 0
	local max_rad = 10
	local ents = TheSim:FindEntities(x,y,z, max_rad, {"fire"})
    for k,v in pairs(ents) do 
    	if v.components.burnable and v.components.burnable.burning then
    		local sz = 5
    		local rad = v.components.burnable:GetLargestLightRadius() or 1
    		sz = sz * ( math.min(max_rad, rad) / max_rad )
			local distsq = inst:GetDistanceSqToInst(v)
			delta = delta + sz/math.max(1, distsq)
    	end
    end
    return delta
end

-- Meat Lover
local function FoodAdjust(inst, food)
	
	if (food.components.edible.foodtype == "MEAT") then
		inst.components.hunger.current = (inst.components.hunger.current - food.components.edible.hungervalue * 0.75)
		food.components.edible.hungervalue = food.components.edible.hungervalue * 2
	end
	
	if (food.components.edible.foodtype == "VEGGIE") then
		inst.components.hunger.current = (inst.components.hunger.current - food.components.edible.hungervalue * 0.75)
		food.components.edible.hungervalue = food.components.edible.hungervalue * 0.5
	end
end

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "emilyvolviing.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(200)
	inst.components.hunger:SetMax(80)
	inst.components.sanity:SetMax(250)
	
	-- Dragon Stats
	inst.components.health.fire_damage_scale = 0
	inst.components.temperature.maxtemp = 500
	inst.components.temperature.mintemp = -5
	
	-- Has Cute and Puffy Sweater Stats
	inst.components.temperature.inherentinsulation = 2
	
	-- Dragon Claws Stats
    inst.components.combat.damagemultiplier = 1.2
	
	-- Hunger Stats
	inst.components.hunger.hungerrate = 0.3 * TUNING.WILSON_HUNGER_RATE
	inst.components.eater:SetOnEatFn(FoodAdjust)
	inst.components.eater.strongstomach = true
	
	-- Movement speed
	inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 8
	
	-- Extra Things
	inst.Transform:SetScale(0.8,0.8,0.8)
	inst.components.inventory:GuaranteeItems(start_inv)
	inst.components.sanity.custom_rate_fn = sanityfn
	inst.components.sanity.night_drain_mult = 0
	
	inst:AddTag("Emily")

end

return MakePlayerCharacter("emilyvolviing", prefabs, assets, fn, start_inv)
