local assets =
{
	Asset("ANIM", "anim/torch.zip"),
	Asset("ANIM", "anim/swap_torch.zip"),
	Asset("SOUND", "sound/common.fsb"),
	
	Asset("ATLAS", "images/inventoryimages/emmafire.xml"),
    Asset("IMAGE", "images/inventoryimages/emmafire.tex"),
}
 
local prefabs =
{
	"emmafire_light",
	"emmatuning"
}    

local function onequip(inst, owner) 
    --owner.components.combat.damage = TUNING.PICK_DAMAGE 
    inst.components.burnable:Ignite()
    owner.AnimState:OverrideSymbol("swap_object", "swap_torch", "swap_torch")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
    
    inst.SoundEmitter:PlaySound("dontstarve/wilson/torch_LP", "torch")
    inst.SoundEmitter:PlaySound("dontstarve/wilson/torch_swing")
    inst.SoundEmitter:SetParameter( "torch", "intensity", 1 )

    inst.fire = SpawnPrefab( "emmafire_light" )
    local follower = inst.fire.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -110, 1 )
    
end

local function onunequip(inst,owner) 
	inst.fire:Remove()
    inst.fire = nil
    
    inst.components.burnable:Extinguish()
    owner.components.combat.damage = owner.components.combat.defaultdamage 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
    inst.SoundEmitter:KillSound("torch")
    inst.SoundEmitter:PlaySound("dontstarve/common/fireOut")        
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    anim:SetBank("torch")
    anim:SetBuild("torch")
    anim:PlayAnimation("idle")
    MakeInventoryPhysics(inst)
    
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.EMMAFIRE_ATTACK_DAMAGE)
    inst.components.weapon:SetAttackCallback(
        function(attacker, target)
            if target.components.burnable then
                if math.random() < TUNING.EMMAFIRE_ATTACK_IGNITE_PERCENT * target.components.burnable.flammability then
                    target.components.burnable:Ignite()
                end
            end
        end
    )
    
    -----------------------------------
	
    inst:AddComponent("lighter")
	
    -----------------------------------
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/emmafire.xml"
	
    -----------------------------------
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnPocket( function(owner) inst.components.burnable:Extinguish()  end)
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    -----------------------------------
    
    inst:AddComponent("inspectable")
	
	-----------------------------------
    
    inst:AddComponent("heater")
    inst.components.heater.equippedheat = 10
 
    -----------------------------------
    
    inst:AddComponent("burnable")
    inst.components.burnable.canlight = false
    inst.components.burnable.fxprefab = nil
   
    -----------------------------------
	
	return inst
end

return Prefab( "common/inventory/emmafire", fn, assets, prefabs) 