-- Assets
local assets = 
{
	Asset( "ANIM", "anim/player_basic.zip" ),
	Asset( "ANIM", "anim/player_actions.zip" ),
	Asset( "ANIM", "anim/player_actions_axe.zip" ),
	Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
	Asset( "ANIM", "anim/player_attacks.zip" ),
	Asset( "ANIM", "anim/player_idles.zip" ),
	Asset( "ANIM", "anim/player_jump.zip" ),
	
	Asset("ANIM", "anim/sarahvolviing.zip"),
	Asset("SOUND", "sound/willow.fsb"),
}

-- Prefabs
local prefabs = 
{

}

-- Equipable Items
local items =
{
	AXE = "swap_axe",
	PICK = "swap_pickaxe",
	SWORD = "swap_spear",
}

-- Equip Items
local function EquipItem(inst, item)
	if item then
		inst.AnimState:OverrideSymbol("swap_object", item, item)
		inst.AnimState:Show("ARM_carry") 
		inst.AnimState:Hide("ARM_normal")
	else
		inst.AnimState:Hide("ARM_carry") 
		inst.AnimState:Show("ARM_normal")
	end
end

-- Attacking Targets
local function KeepTarget(isnt, target)
	return target and target:IsValid()
end

-- Acceptable Items
local function ShouldAcceptItem(inst, item)	
	if (item.prefab == "goldnugget") then
		return true
	end
	
	if item.components.edible then
        if (item.components.edible.foodtype == "MEAT" or item.components.edible.foodtype == "VEGGIES") then
			return true
		end
	end	
	
	if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
		return true
	end
end

-- Take Items
local function OnGetItemFromPlayer(inst, giver, item)
	if item.components.edible then
		if (item.components.edible.foodtype == "VEGGIES") then
		inst.components.health:DoDelta(10)
		inst.AnimState:PlayAnimation("quickeat")
		inst.components.follower:SetLeader(giver)
		inst.components.talker.fontsize = 18
		inst.components.talker:Say("Thanks for the snack.")
	end
end
	if item.components.edible then
		if (item.components.edible.foodtype == "MEAT") then
		inst.components.health:DoDelta(25)
		inst.AnimState:PlayAnimation("eat")
		inst.components.follower:SetLeader(giver)
		inst.components.talker.fontsize = 21
		inst.components.talker:Say("Thanks for the Meal Sis!")
	end
end
	if (item.prefab == "goldnugget") then
		inst.components.health:DoDelta(150)
		inst.components.talker.fontsize = 25
		inst.components.follower:SetLeader(giver)
		inst.components.talker:Say("Gold! Thank you!")
	end
	
	-- Hats
	if item.components.equippable and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
        local current = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        if current then
            inst.components.inventory:DropItem(current)
        end
        inst.components.talker.fontsize = 25
		inst.components.talker:Say("A hat for me? Thanks Sis!")
        inst.components.inventory:Equip(item)
	end
end

-- Refuse Items
local function OnRefuseItem(inst, item)
	local playerprefab = GetPlayer()
		if playerprefab then
		inst.AnimState:PlayAnimation("give")
		inst.components.talker.fontsize = 21
		playerprefab.components.talker:Say("No Thanks, You can keep that.")
	end
end

-- Attacked
local function OnAttacked(inst, data)
	local attacker = data.attacker
	if attacker and not attacker:HasTag("Emily") then
	inst.components.combat:SetTarget(attacker)
	return target
	end
end
-- Stats
local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	
	-- Tags
	inst:AddTag("companion")
	inst:AddTag("scarytoprey")
	inst:AddTag("character")
	inst:AddTag("notraptrigger")

	-- Scale
	inst.Transform:SetFourFaced(inst)
	inst.Transform:SetScale(0.5, 0.5, 0.5)

	-- Physics
	MakeCharacterPhysics(inst, 75, .5)
	inst.Physics:ClearCollisionMask()
	inst.Physics:CollidesWith(COLLISION.WORLD)
	MakeObstaclePhysics(inst, 1)

	-- Sound and Animation
	inst.soundsname = "willow"
	anim:SetBank("wilson")
	anim:SetBuild("sarahvolviing")

	-- Movement
	inst:AddComponent("locomotor")
	inst.components.locomotor.walkspeed = 8
	inst.components.locomotor.runspeed = 10
	
	-- Equip Items
	inst.items = items
	inst.equipfn = EquipItem
	EquipItem(inst)


	local function OnStartFollowing(inst) 
		inst:AddTag("companion") 
	end

	if not GetPlayer().components.leader:AddFollower(inst) then
		GetPlayer().components.leader:AddFollower(inst)
	end

-----------------------------------------------------------

	inst:AddComponent("combat")
	inst.components.combat.hiteffectsymbol = "torso"
	inst.components.combat:SetKeepTargetFunction(KeepTarget)
	inst.components.combat:SetAttackPeriod(0.45)
	inst.components.combat:SetDefaultDamage(25)
	inst.components.combat:SetRange(1, 1)
	inst:ListenForEvent("attacked", OnAttacked) 
	
-----------------------------------------------------------

	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(150)
	inst.components.health.nofadeout = true
	inst.components.health.fire_damage_scale = 0

-----------------------------------------------------------


	
-----------------------------------------------------------

	inst:AddComponent("inventory")
	
-----------------------------------------------------------

	inst:AddComponent("lootdropper")

	inst.components.lootdropper:AddRandomLoot("goldnugget",2)
	inst.components.lootdropper:AddRandomLoot("goldnugget",1)
	inst.components.lootdropper.numrandomloot = 1
	
-----------------------------------------------------------

	local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "images/map_icons/sarahsmall.xml" )
	
-----------------------------------------------------------
	
	inst:AddComponent("follower")
	
-----------------------------------------------------------

	inst:AddComponent("eater")
	
-----------------------------------------------------------

	local brain = require "brains/sarahsmallbrain"
	inst:SetBrain(brain)
	inst:SetStateGraph("SGsarahsmall")
	
-----------------------------------------------------------

	inst:AddComponent("trader")
	inst.components.trader:SetAcceptTest(ShouldAcceptItem)
	inst.components.trader.onaccept = OnGetItemFromPlayer
	inst.components.trader.onrefuse = OnRefuseItem
	
-----------------------------------------------------------
	
	inst:AddComponent("talker")
	inst.components.talker.fontsize = 21 
	inst.components.talker:StopIgnoringAll()
	
-----------------------------------------------------------
	return inst
end

return Prefab("common/sarahsmall", fn, assets, prefabs)