
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/wol.zip" ),
		Asset( "ANIM", "anim/wol_fury.zip" ),
}
local prefabs = {}

local function updatestats(inst)
	
		if inst.strength == "mighty" then
		    
			inst.components.health:StopRegen()
			inst.components.combat.damagemultiplier = 1.3
			inst.components.combat.defaultdamage = 1
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
			inst.components.temperature.hurtrate = TUNING.WILSON_HEALTH / TUNING.FREEZING_KILL_TIME
			inst.components.health.fire_damage_scale=1
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.3)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.3)
			inst.AnimState:SetBuild("wol")
		elseif inst.strength == "normal" then
		    
			inst.components.health:StartRegen(1, 5)
			inst.components.combat.damagemultiplier = 1.1
			inst.components.combat.defaultdamage = 1
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)	
			inst.components.temperature.hurtrate = TUNING.WILSON_HEALTH / TUNING.FREEZING_KILL_TIME
			inst.components.health.fire_damage_scale=1
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED)
			inst.AnimState:SetBuild("wol")
		elseif inst.strength == "wimpy" then
		    
			inst.components.health:StartRegen(3, 0.5)
			inst.components.combat.damagemultiplier = 1,8
			inst.components.combat.defaultdamage = TUNING.SPEAR_DAMAGE
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*4)
			inst.components.sanity.current = 80
			inst.components.temperature.hurtrate = 0
			inst.components.health.fire_damage_scale=0
			inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.5)
			inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.5)
			inst.AnimState:SetBuild("wol_fury")
		end		
	
		
end

local function onhealthchange(inst, data)

	if      inst.strength == "mighty" then
	    if  inst.components.health.currenthealth >= 50 then
            inst.strength = "normal"
			inst.components.talker:Say("My wounds are healed ...")
		end
	
    elseif  inst.strength == "wimpy" then
	    if  inst.components.health.currenthealth >= 40 then
            inst.strength = "normal"
			inst.components.talker:Say("My wounds are healed ...")
		end	
	        
	    
	elseif  inst.components.health.currenthealth < 40 then
			inst.strength = "wimpy"
	        inst.components.talker:Say("FURY!")
		
	elseif  inst.components.health.currenthealth == 200 then
			inst.strength = "mighty"
			inst.components.talker:Say("I was healed!")
			
	end
	updatestats(inst)
end

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wolfgang"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wilson.png" )
	
	

	-- todo: Add an example special power here.
	inst.components.sanity:SetMax(TUNING.WILSON_SANITY-70)
	inst.components.health:SetMaxHealth(TUNING.WILSON_HEALTH+50)
	inst.components.hunger:SetMax(TUNING.WILSON_HUNGER-50)

	
	
	inst.strength = "normal"
	inst.components.health.currenthealth = 100
	
	
	inst:ListenForEvent("healthdelta", onhealthchange)
	inst:ListenForEvent("hungerdelta", updatestats)
	


end

STRINGS.CHARACTER_TITLES.wol = "Fearless and invincible!"
STRINGS.CHARACTER_NAMES.wol = "Wolverine"
STRINGS.CHARACTER_DESCRIPTIONS.wol = "*Regeneration.\n*Fury."
STRINGS.CHARACTER_QUOTES.wol = "\"I'm a beast.\""


return MakePlayerCharacter("wol", prefabs, assets, fn)
