local assets=
{
	Asset("ANIM", "anim/mushasword4.zip"),
	Asset("ANIM", "anim/swap_mushasword4.zip"),
    	Asset("ATLAS", "images/inventoryimages/mushasword4.xml"),
	Asset("IMAGE", "images/inventoryimages/mushasword4.tex"),

}
---------------------------
local function levelexp(inst,data)

	local max_exp = 4100
	local exp = math.min(inst.level, max_exp)

if inst.level <= 4000 then
inst.components.talker:Say("-[Phoenix Axe]- \n[Grow Points]".. (inst.level))
inst:RemoveTag("levelup")
end
if inst.level >=0 and inst.level <800 then
inst.components.talker:Say("-[Phoenix Axe]- \nNext:[800]\n[Grow Points]".. (inst.level))
inst:AddTag("level1")
elseif inst.level >=800 and inst.level <1600 then
inst.components.talker:Say("-[Phoenix Axe]- \nNext:[1600]\n[Grow Points]".. (inst.level))
inst:AddTag("level2")
inst:RemoveTag("level1")
elseif inst.level >=1600 and inst.level <2400 then
inst.components.talker:Say("-[Phoenix Axe]- \nNext:[2400]\n[Grow Points]".. (inst.level))
inst:AddTag("level3")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
elseif inst.level >=2400 and inst.level <4000 then
inst.components.talker:Say("-[Phoenix Axe]- \nNext:[4000]\n[Grow Points]".. (inst.level))
inst:AddTag("level4")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
elseif inst.level >=4000 then
inst.components.talker:Say("-[Phoenix Axe]- \n[MAX]")
inst:AddTag("level5")
inst:RemoveTag("level1")
inst:RemoveTag("level2")
inst:RemoveTag("level3")
inst:RemoveTag("level4")
end
end

local function onpreload(inst, data)
	if data then
		if data.level then
		inst.level = data.level
			levelexp(inst)
end
	end
		end
local function onsave(inst, data)
	data.level = inst.level
	data.charge_time = inst.charge_time
end

local function OnDurability(inst, data)
inst:AddTag("broken")
    inst.components.weapon:SetDamage(1)
	inst.components.talker:Say("-Broken PhoenixAxe \nDamage (1)")
end

local function Upgradedamage(inst)
if inst.components.fueled:IsEmpty() then
inst:AddTag("broken") 
   inst.components.weapon:SetDamage(1)
	inst.components.talker:Say("-Broken PhoenixAxe \nDamage (1)")
end
if inst:HasTag("broken") then
   inst.components.weapon:SetDamage(1)
    inst.components.equippable.walkspeedmult = 1
	inst.components.talker:Say("-Broken PhoenixAxe \nDamage (1)")
   end
if not inst:HasTag("broken") then
        if inst:HasTag("level1") then
    inst.components.weapon:SetDamage(62)
    inst.components.equippable.walkspeedmult = 1.03
	inst.components.talker:Say("[Phoenix Axe (LV1)]\nDamage (62)\nCritical(5per)\nSpeed up(3)")
        elseif inst:HasTag("level2") then
    inst.components.weapon:SetDamage(65)
    inst.components.equippable.walkspeedmult = 1.06
	inst.components.talker:Say("[Phoenix Axe (LV2)]\nDamage (65)\nCritical(8per)\nSpeed up(6)")
        elseif inst:HasTag("level3") then
    inst.components.weapon:SetDamage(68)
    inst.components.equippable.walkspeedmult = 1.09
	inst.components.talker:Say("[(Phoenix Axe (LV3)]\nDamage (68)\nCritical(12per)\nSpeed up(9)")
        elseif inst:HasTag("level4") then
    inst.components.weapon:SetDamage(71)
    inst.components.equippable.walkspeedmult = 1.12
	inst.components.talker:Say("[Phoenix Axe (LV4)]\nDamage (71)\nCritical(16per)\nSpeed up(12)")
        elseif inst:HasTag("level5") then
    inst.components.weapon:SetDamage(74)
    inst.components.equippable.walkspeedmult = 1.15
	inst.components.talker:Say("[Phoenix Axe (LV5)]\nDamage (74)\nCritical(20per)\nSpeed up(15)")
end
end
end
-------- --------
local function TakeItem(inst, item, data)
local expchance0 = 1
local expchance1 = 0.3
local expchance2 = 0.2
local expchance3 = 0.12
	inst.components.fueled:DoDelta(5000000)
	SpawnPrefab("splash").Transform:SetPosition(inst:GetPosition():Get())
inst:RemoveTag ("broken")     
Upgradedamage(inst)
   if math.random() < expchance1 and inst.level <= 4005 then
	inst.level = inst.level + 2
	levelexp(inst)
	inst.components.talker:Say("Lucky Points ! +(2)\n[Grow Points]".. (inst.level))
    elseif  math.random() < expchance2 and inst.level <= 4005 then
	inst.level = inst.level + 5
	levelexp(inst)
	inst.components.talker:Say("Lucky Points ! +(5)\n[Grow Points]".. (inst.level))
	elseif  math.random() < expchance3 and inst.level <= 4005 then
	inst.level = inst.level + 8
	levelexp(inst)
	inst.components.talker:Say("Lucky Points ! +(8)\n[Grow Points]".. (inst.level))
	elseif  math.random() < expchance0 and inst.level <= 4005 then
	inst.level = inst.level + 1
	levelexp(inst)
    end
end
local function OnLoad(inst, data)
    Upgradedamage(inst)
end

local function getrandomposition(inst)
    local ground = GetWorld()
    local centers = {}
    for i,node in ipairs(ground.topology.nodes) do
        local tile = GetWorld().Map:GetTileAtPoint(node.x, 0, node.y)
        if tile and tile ~= GROUND.IMPASSABLE then
			table.insert(centers, {x = node.x, z = node.y})
		end
    end
    if #centers > 0 then
		local pos = centers[math.random(#centers)]
		return Point(pos.x, 0, pos.z)
	else
		return GetPlayer():GetPosition()
	end
end

local function canteleport(inst, caster, target)
    if target then
        return target.components.locomotor ~= nil
    end

    return true
end

local function teleport_thread(inst, caster, teletarget, loctarget)
    local ground = GetWorld()

    local t_loc = nil
    if loctarget then
        t_loc = loctarget:GetPosition()
    else
        t_loc = getrandomposition()
    end

    local teleportee = teletarget
    local pt = teleportee:GetPosition()
    if teleportee.components.locomotor then
        teleportee.components.locomotor:StopMoving()
    end

    if ground.topology.level_type == "cave" then
        TheCamera:Shake("FULL", 0.3, 0.02, .5, 40)
        ground.components.quaker:MiniQuake(3, 5, 1.5, teleportee)     
        return
    end

    if teleportee.components.health then
        teleportee.components.health:SetInvincible(true)
    end
    
    GetSeasonManager():DoLightningStrike(pt)
    teleportee:Hide()

    if teleportee == GetPlayer() then
        TheFrontEnd:Fade(false, 2)
        Sleep(3)
    end
    
    if caster.components.sanity then
        caster.components.sanity:DoDelta(-TUNING.SANITY_HUGE)
    end
    if ground.components.seasonmanager then
        ground.components.seasonmanager:ForcePrecip()
    end

    teleportee.Transform:SetPosition(t_loc.x, 0, t_loc.z)

    if teleportee == GetPlayer() then
        TheCamera:Snap()
        TheFrontEnd:DoFadeIn(1)
        Sleep(1)
    end
    if loctarget and loctarget.onteleto then loctarget.onteleto(loctarget) end
    GetSeasonManager():DoLightningStrike(t_loc)
    teleportee:Show()
    if teleportee.components.health then
        teleportee.components.health:SetInvincible(false)
    end

    if teleportee == GetPlayer() then
        teleportee.sg:GoToState("wakeup")
        teleportee.SoundEmitter:PlaySound("dontstarve/common/staffteleport")
    end
end

local function teleport_func(inst, target)
    local mindistance = 1
    local caster = inst.components.inventoryitem.owner
    local tar = target or caster
    local pt = tar:GetPosition()
    local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 9000, {"telebase"})

    if #ents <= 0 then
        --There's no bases, active or inactive. Teleport randomly.
        inst.task = inst:StartThread(function() teleport_thread(inst, caster, tar) end)
        return
    end

    local targets = {}
    for k,v in pairs(ents) do
        local v_pt = v:GetPosition()
        if distsq(pt, v_pt) >= mindistance * mindistance then
            table.insert(targets, {base = v, distance = distsq(pt, v_pt)}) 
        end
    end

    table.sort(targets, function(a,b) return (a.distance) < (b.distance) end)
    for i = 1, #targets do
        local teletarget = targets[i]
        if teletarget.base and teletarget.base.canteleto(teletarget.base) then
            inst.task = inst:StartThread(function()  teleport_thread(inst, caster, tar, teletarget.base) end)
            return
        end
    end

    inst.task = inst:StartThread(function() teleport_thread(inst, caster, tar) end)
end


local function onattack_FRAME(inst, attacker, target)
local player = GetPlayer()
local framechance1 = 0.05
local framechance2 = 0.08
local framechance3 = 0.12
local framechance4 = 0.16
local framechance5 = 0.2
local expchance = 0.05
local damagedur1 = 0.2
local damagedur2 = 0.5
local damagedur3 = 0.7
local damagedur4 = 1


if math.random() < expchance and not inst:HasTag("broken") and inst.level < 4010 then
	inst.level = inst.level + 1
	levelexp(inst)
end
    if target and not inst:HasTag("broken") and math.random() < damagedur1 then
inst.components.fueled:DoDelta(-150000)
    elseif target and not inst:HasTag("broken") and math.random() < damagedur2 then
inst.components.fueled:DoDelta(-75000)
    elseif target and not inst:HasTag("broken") and math.random() < damagedur3 then
inst.components.fueled:DoDelta(-35000)
    elseif target and not inst:HasTag("broken") and math.random() < damagedur4 then
inst.components.fueled:DoDelta(-20000)
    elseif target and inst:HasTag("broken") then
		local fx = SpawnPrefab("splash")
	local pos = Vector3(target.Transform:GetWorldPosition())
fx.Transform:SetPosition(pos:Get())
	inst.components.talker:Say("-Broken Weapon \nDamage (1)")
    end

  	  if target and target.components.burnable and inst:HasTag("level1") and not target:HasTag("wall") and not target:HasTag("structure") and math.random() < framechance1 and not player:HasTag("framea") then
        target.components.burnable:Ignite()
local fx = SpawnPrefab("statue_transition")
local pos = Vector3(target.Transform:GetWorldPosition())
	fx.Transform:SetPosition(pos:Get())
        target.components.health:DoDelta(-50)
        attacker.components.health:DoDelta(15)
  	  elseif target and target.components.burnable and inst:HasTag("level2") and not target:HasTag("wall") and not target:HasTag("structure") and math.random() < framechance1 and not player:HasTag("framea") then
        target.components.burnable:Ignite()
local fx = SpawnPrefab("statue_transition")
local pos = Vector3(target.Transform:GetWorldPosition())
	fx.Transform:SetPosition(pos:Get())
        target.components.health:DoDelta(-52)
        attacker.components.health:DoDelta(15)
  	  elseif target and target.components.burnable and inst:HasTag("level3") and not target:HasTag("wall") and not target:HasTag("structure") and math.random() < framechance1 and not player:HasTag("framea") then
        target.components.burnable:Ignite()
local fx = SpawnPrefab("statue_transition")
local pos = Vector3(target.Transform:GetWorldPosition())
	fx.Transform:SetPosition(pos:Get())
        target.components.health:DoDelta(-54)
        attacker.components.health:DoDelta(15)
  	  elseif target and target.components.burnable and inst:HasTag("level4") and not target:HasTag("wall") and not target:HasTag("structure") and math.random() < framechance1 and not player:HasTag("framea") then
        target.components.burnable:Ignite()
local fx = SpawnPrefab("statue_transition")
local pos = Vector3(target.Transform:GetWorldPosition())
	fx.Transform:SetPosition(pos:Get())
        target.components.health:DoDelta(-56)
        attacker.components.health:DoDelta(15)
  	  elseif target and target.components.burnable and inst:HasTag("level5") and not target:HasTag("wall") and not target:HasTag("structure") and math.random() < framechance1 and not player:HasTag("framea") then
        target.components.burnable:Ignite()
local fx = SpawnPrefab("statue_transition")
local pos = Vector3(target.Transform:GetWorldPosition())
	fx.Transform:SetPosition(pos:Get())
        target.components.health:DoDelta(-58)
        attacker.components.health:DoDelta(15)

    elseif target.components.burnable and target.sg and not target.sg:HasStateTag("frozen") and not target:HasTag("wall") and not target:HasTag("structure") and player:HasTag("framea")  then
            target.sg:GoToState("hit")
        target.components.burnable:Ignite()
local fx = SpawnPrefab("statue_transition")
local pos = Vector3(target.Transform:GetWorldPosition())
	fx.Transform:SetPosition(pos:Get())
        attacker.components.sanity:DoDelta(-15)
        attacker.components.health:DoDelta(50)
        --attacker.components.health:DoDelta(TUNING.BATBAT_DRAIN,false,"batbat")
		target.components.health:DoDelta(-112)
		player:RemoveTag("framea") 
    end
    if target.components.burnable and target.components.burnable:IsBurning() then
        target.components.burnable:Extinguish()
    end
    if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
    end
		player:RemoveTag("framea") 
end

local function onattack_blood(inst, owner, target)
    if owner.components.health and owner.components.health:GetPercent() < 1 and not target:HasTag("wall") then
        owner.components.health:DoDelta(2)
        --owner.components.sanity:DoDelta(-TUNING.BATBAT_DRAIN * 0.5)
    end
end

local function OnDropped(inst,data)
   inst:AddTag("talkf")
    end
local function OnPutInInventory(inst)
   inst:RemoveTag("talkf")
    end

local function onequip(inst, owner)
local player = GetPlayer()
    Upgradedamage(inst)
   inst:AddTag("talkf")
    owner.AnimState:OverrideSymbol("swap_object", "swap_mushasword4", "swap_batbat")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
		player:AddTag("phoenixblade") 
end
local function onunequip(inst, owner) 
local player = GetPlayer()
    Upgradedamage(inst)
   inst:RemoveTag("talkf")
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
		player:RemoveTag("framea") 
		player:RemoveTag("phoenixblade") 
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("batbat")
    inst.AnimState:SetBuild("mushasword4")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetMultColour(1, 1, 1, 0.6)

    inst:AddTag("sharp")
        inst:AddTag("metal")
    inst:AddComponent("weapon")
   -- inst.components.weapon:SetDamage(TUNING.HAMBAT_DAMAGE)
    inst.components.weapon:SetDamage(90)
    inst.components.weapon:SetOnAttack(Upgradedamage)

      inst.components.weapon:SetOnAttack(onattack_FRAME)
   -- inst.components.weapon.onattack = onattack_blood
     


    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    	inst.components.inventoryitem.atlasname = "images/inventoryimages/mushasword4.xml"
     inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "blade_4.tex" )

        inst.entity:AddLight()
	inst.Light:SetRadius(.3)
    inst.Light:SetFalloff(.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(250/255,65/255,65/255)
	inst.Light:Enable(true)
    inst.OnLoad = OnLoad

inst:AddComponent("talker")
    inst.components.talker.fontsize = 19
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(1, 0.8, 0.65, 1)
    inst.components.talker.offset = Vector3(200,-250,0)

    inst.components.talker.symbol = "swap_object"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(teleport_func)
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster:SetSpellTestFn(canteleport)
    inst:AddTag("nopunch")

        inst:AddComponent("fueled")
       inst.components.fueled.fueltype = "CHEMICAL"
        inst.components.fueled:InitializeFuelLevel(20000000)
       inst.components.fueled:SetDepletedFn(OnDurability)
        inst.components.fueled.ontakefuelfn = TakeItem
        inst.components.fueled.accepting = true
inst.components.fueled:StopConsuming()        

inst:AddTag("level1")
	inst.level = 0
inst:ListenForEvent("levelup", levelexp)
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload

    return inst
end

return Prefab( "common/inventory/mushasword4", fn, assets) 
