
local assets =
{
	Asset("ANIM", "anim/red_splash.zip"),
	Asset("ANIM", "anim/green_splash.zip"),
	Asset("ANIM", "anim/yellow_splash.zip"),
	Asset("ANIM", "anim/orange_splash.zip"),
}

local prefab =
{
    "red_splash",    
    "orange_splashs",
    "yellow_splash",
    "green_splash",
}
local function red_splash(Sim)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()

    anim:SetBank("ice_splash")
    anim:SetBuild("red_splash")
    anim:PlayAnimation("full")
    
    inst:AddTag("fx")

    return inst
end

local function green_splash(Sim)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()

    anim:SetBank("ice_splash")
    anim:SetBuild("green_splash")
    anim:PlayAnimation("full")
    
    inst:AddTag("fx")

    return inst
end

local function orange_splash(Sim)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()

    anim:SetBank("ice_splash")
    anim:SetBuild("orange_splash")
    anim:PlayAnimation("full")
    
    inst:AddTag("fx")

    return inst
end

local function yellow_splash(Sim)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()

    anim:SetBank("splash")
    anim:SetBuild("yellow_splash")
    anim:PlayAnimation("full")
    
    inst:AddTag("fx")

    return inst
end

return Prefab("common/fx/red_splash", red_splash, assets, prefab),
		Prefab( "common/fx/green_splash", green_splash, assets, prefab),
		Prefab( "common/fx/orange_splash", orange_splash, assets, prefab),
		Prefab( "common/fx/yellow_splash", yellow_splash, assets, prefab)