/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.core;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import grim3212.mc.core.GrimModule;
import grim3212.mc.core.block.GenericBlock;
import grim3212.mc.core.creative.CreativeTabGrimBlocks;
import grim3212.mc.core.creative.CreativeTabGrimItems;
import grim3212.mc.core.lib.Config;
import grim3212.mc.core.packet.PacketPipeline;
import grim3212.mc.core.util.VersionChecker;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

@Mod(modid="grim3212core", name="Grim3212 Core", version="V0.2 - 1.7.2")
public class Grim3212Core
extends GrimModule {
    @Mod.Instance(value="grim3212core")
    public static Grim3212Core instance;
    public static CreativeTabs tabsGrimBlocks;
    public static CreativeTabs tabsGrimItems;
    public static boolean doUpdateCheck;
    private static VersionChecker versionChecker;
    public static boolean canVersionCheck;
    public static Item grimCoreItem;
    public static Block grimCoreBlock;
    public static final PacketPipeline packetPipeline;

    @Mod.EventHandler
    public void load(FMLPreInitializationEvent event) {
        ModMetadata data = event.getModMetadata();
        data.autogenerated = false;
        data.version = "V0.2 - 1.7.2";
        data.name = "Grim3212 Core";
        data.description = "The core mod that all of grims mods require.";
        data.authorList.add("Grim3212");
        data.url = "http://grim3212.wikispaces.com/Grim3212+Core";
        data.credits = "Thanks to Grim3212 for the original mod.";
        data.logoFile = "assets/grim3212-logo-texture/grimLogo.png";
        Config.init(new File(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "/GrimsMods/" + this.getModID() + ".cfg"));
        grimCoreItem = new Item().func_77655_b("grimCoreItem").func_111206_d(this.getModID() + ":itemCore").func_77637_a(tabsGrimItems);
        grimCoreBlock = new GenericBlock(Material.field_151573_f).func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(Block.field_149777_j).func_149663_c("grimBlockItem").func_149658_d(this.getModID() + ":blockCore");
        GameRegistry.registerBlock((Block)grimCoreBlock, (String)"grimCoreBlock");
        GameRegistry.registerItem((Item)grimCoreItem, (String)"grimCoreItem", (String)"grim3212core");
        GameRegistry.addRecipe((ItemStack)new ItemStack(grimCoreItem, 1), (Object[])new Object[]{" G ", "IXI", " G ", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), Items.field_151043_k});
        GameRegistry.addRecipe((ItemStack)new ItemStack(grimCoreItem, 1), (Object[])new Object[]{" G ", "IXI", " G ", Character.valueOf('X'), Items.field_151045_i, Character.valueOf('I'), Items.field_151043_k, Character.valueOf('G'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(grimCoreBlock, 1), (Object[])new Object[]{" G ", "IXI", " G ", Character.valueOf('X'), Blocks.field_150484_ah, Character.valueOf('I'), Blocks.field_150339_S, Character.valueOf('G'), Blocks.field_150340_R});
        GameRegistry.addRecipe((ItemStack)new ItemStack(grimCoreBlock, 1), (Object[])new Object[]{" G ", "IXI", " G ", Character.valueOf('X'), Blocks.field_150484_ah, Character.valueOf('I'), Blocks.field_150340_R, Character.valueOf('G'), Blocks.field_150339_S});
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        doUpdateCheck = Config.allowVersionCheckGlobal;
        if (doUpdateCheck) {
            versionChecker = new VersionChecker("Grim3212 Core", "V0.2 - 1.7.2", this.versionUrl, "http://grim3212.wikispaces.com/Grim3212+Core");
            versionChecker.checkVersionWithLoggingBySubStringAsFloat(1, 4);
        }
        packetPipeline.initialise();
    }

    @Mod.EventHandler
    public void postInitialise(FMLPostInitializationEvent evt) {
        packetPipeline.postInitialise();
    }

    @Override
    public String getModID() {
        return "grim3212core";
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (FMLClientHandler.instance().getClient().field_71462_r == null && doUpdateCheck) {
            if (canVersionCheck && !versionChecker.isCurrentVersionBySubStringAsFloatNewer(1, 4)) {
                for (String msg : versionChecker.getInGameMessage()) {
                    FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(msg));
                }
                canVersionCheck = false;
            }
        }
    }

    static {
        tabsGrimBlocks = new CreativeTabGrimBlocks(CreativeTabs.getNextID(), "grim3212core");
        tabsGrimItems = new CreativeTabGrimItems(CreativeTabs.getNextID(), "grim3212core");
        canVersionCheck = true;
        packetPipeline = new PacketPipeline();
    }
}

