
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
    Asset("ANIM", "anim/hz_ch_gilgamesh.zip"),


}
local prefabs = {
	"gate_of_babylon",
}

-- Custom starting items
local start_inv = {
"gate_of_babylon",
"gate_of_babylon",
"gate_of_babylon",

}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	
	inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
    inst.AnimState:SetBuild("hz_ch_gilgamesh")
end

local mintime = 10

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "archer.tex" )
	inst:AddTag("archerbuilder")
	inst:AddTag("gilgamesh")

	
end

local smallScale = 1.2
local medScale = 1.5
local largeScale = 2

local function onkilled(inst, data)
    local victim = data.victim
    if not (victim:HasTag("prey") or
            victim:HasTag("veggie") or
            victim:HasTag("structure")) then
        local delta = victim.components.combat.defaultdamage * 0.25
        inst.components.health:DoDelta(delta, false, "battleborn")
        inst.components.sanity:DoDelta(delta)

        if not victim.components.health.nofadeout and (victim:HasTag("epic") or math.random() < .1) then
            local time = victim.components.health.destroytime or 2
            local x, y, z = victim.Transform:GetWorldPosition()
            local scale = (victim:HasTag("smallcreature") and smallScale)
                        or (victim:HasTag("largecreature") and largeScale)
                        or medScale
        end
    end
end

local effect_recipes =
{
        "gate_of_babylon",

}

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "archer"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	--inst.AnimState:SetBuild("hz_ch_gilgamesh")
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(250)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE *0.3)
        inst.components.health.absorb = 0.2
        inst.components.sanity.night_drain_mult=0
        inst.components.sanity.neg_aura_mult=0
        inst.components.combat.min_attack_period =0.1
        inst.components.locomotor.walkspeed = (6)
	    inst.components.locomotor.runspeed = (8)
        inst.components.combat:SetDefaultDamage(0)
        inst.components.combat:SetRange(30,40)



--inst.components.temperature.mintemp = 20


   --     inst.Light:Enable(true)
	--   inst.Light:SetRadius(3)
	--   inst.Light:SetFalloff(.2)
	--  inst.Light:SetIntensity(.8)
	--inst.Light:SetColour(44/128,97/148,158/48)
	
	inst.components.health.absorb = 0.25
		
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	inst:ListenForEvent("killed", onkilled)
	
    local old_onenter = inst.sg.sg.states.talk.onenter
    inst.sg.sg.states.talk.onenter = function(inst, noanim)
        old_onenter(inst, noanim)
        inst.sg:SetTimeout(mintime + math.random() * 0.5)
    end
		
local _DoBuild = inst.components.builder.DoBuild
inst.components.builder.DoBuild = function( self, recname, pt, rotation, skin )
        if self.inst.components.sanity.current < 10 then
                return false
        end
		
	-- If you want it only on specific recipes
	for _, v in pairs(effect_recipes) do
			if recname == v then
					local effect = SpawnPrefab("mossling_spin_fx").entity:AddFollower():FollowSymbol(inst.GUID, "swap_body", 0, 0, 0)
			end
	end
	
        return _DoBuild(self, recname, pt, rotation, skin)
end

end

return MakePlayerCharacter("archer", prefabs, assets, common_postinit, master_postinit, start_inv)
