local assets=
{
   -- Asset("ANIM", "anim/bakuya.zip"),
 --   Asset("ANIM", "anim/swap_bakuya.zip"),
  
   -- Asset("ATLAS", "images/inventoryimages/bakuya.xml"),
   -- Asset("IMAGE", "images/inventoryimages/bakuya.tex"),
       Asset("ANIM", "anim/gkatana.zip"),
    Asset("ANIM", "anim/swap_gkatana.zip"),
  
    Asset("ATLAS", "images/inventoryimages/gkatana.xml"),
    Asset("IMAGE", "images/inventoryimages/gkatana.tex"),
}

local prefabs = 
{
  "impact",
}

local function OnDropped(inst)
    inst.AnimState:PlayAnimation("idle")
end

local function OnCaught(inst, catcher)
    if catcher then
        if catcher.components.inventory then
            if inst.components.equippable and not catcher.components.inventory:GetEquippedItem(inst.components.equippable.equipslot) then
                catcher.components.inventory:Equip(inst)
            else
                catcher.components.inventory:GiveItem(inst)
            end
            catcher:PushEvent("catch")
        end
    end
end

local function OnThrown(inst, owner)
inst.AnimState:PlayAnimation("planted")
end


local function onhit(inst, owner,target)
    OnDropped(inst)
    local pos = Vector3(target.Transform:GetWorldPosition())

end



local function OnEquip(inst, owner)
owner.components.combat:SetAreaDamage(3, 3)
    owner.AnimState:OverrideSymbol("swap_object", "swap_gkatana", "swap_gkatana")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

end
  
local function OnUnequip(inst, owner)
    owner.components.combat:SetAreaDamage(3, 3)

    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end


local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
       inst.AnimState:SetBank("gkatana")
    inst.AnimState:SetBuild("gkatana")
   -- inst.AnimState:SetBank("bakuya")
   -- inst.AnimState:SetBuild("bakuya")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")

 
    if not TheWorld.ismastersim then
       return inst
    end
 
    inst.entity:SetPristine()



     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(5)

       

   -- inst:AddComponent("finiteuses")
    --inst.components.finiteuses:SetMaxUses(30)
   -- inst.components.finiteuses:SetUses(30)
    --inst.components.finiteuses:SetOnFinished(inst.Remove)
    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(30)
    inst.components.perishable:StartPerishing()
    inst.components.perishable:SetOnPerishFn(inst.Remove)

    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(20)
    inst.components.projectile:SetCanCatch(false)
    inst.components.projectile:SetHoming(false)
    inst.components.projectile:SetOnThrownFn(OnThrown)
    inst.components.projectile:SetOnHitFn(onhit)
    inst.components.projectile:SetHitDist(3)
    inst.components.projectile:SetOnCaughtFn(OnCaught)
	 

    inst:AddComponent("inspectable")

    
      
    inst:AddComponent("inventoryitem")
    --  inst.components.inventoryitem.imagename = "bakuya"
    --inst.components.inventoryitem.atlasname = "images/inventoryimages/bakuya.xml"
     inst.components.inventoryitem.imagename = "gkatana"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/gkatana.xml"

    inst:AddComponent("stackable")  
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.inventoryitem.keepondeath = true
	inst.components.equippable.equipstack = true

    
    MakeHauntableLaunch(inst)
    
    return inst
end
return  Prefab("common/inventory/archer_bakuya", fn, assets, prefabs) 