local assets=
{
    Asset("ANIM", "anim/galientsword.zip"),
    Asset("ANIM", "anim/swap_galientsword.zip"),
  
    Asset("ATLAS", "images/inventoryimages/galientsword.xml"),
    Asset("IMAGE", "images/inventoryimages/galientsword.tex"),
}


local function OnDropped(inst)
    inst.AnimState:PlayAnimation("idle")
end

local function OnCaught(inst, catcher)
    if catcher then
        if catcher.components.inventory then
            if inst.components.equippable and not catcher.components.inventory:GetEquippedItem(inst.components.equippable.equipslot) then
                catcher.components.inventory:Equip(inst)
            else
                catcher.components.inventory:GiveItem(inst)
            end
            catcher:PushEvent("catch")
        end
    end
end

local function OnThrown(inst, owner)
inst.AnimState:PlayAnimation("planted")
end



local function OnHit(inst, owner, target)
    OnDropped(inst)
    local pos = Vector3(target.Transform:GetWorldPosition())

end



local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_galientsword", "swap_galientsword")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
     local light2 = inst.entity:AddLight()
    light2:SetFalloff(.3)
    light2:SetIntensity(.8)
    light2:SetRadius(3)
    light2:Enable(true)
    light2:SetColour(255/255, 88/255, 112/255)   
end

local function onattack_galient(inst, attacker, data)
	 local x, y, z = inst.Transform:GetWorldPosition()
        if attacker then
    SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
        -- SpawnPrefab("collapse_big").Transform:SetPosition(inst:GetPosition():Get())
        -- SpawnPrefab("caster_ring_fx").Transform:SetPosition(inst:GetPosition():Get())
       SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())

      for aaa = x-6, x+6, 1 do
        SpawnPrefab("caster_ring_fx").Transform:SetPosition(aaa,y,z-6)
        SpawnPrefab("caster_ring_fx").Transform:SetPosition(aaa,y,z+6)
      end
      for bbb = z-6, z+6, 1 do
        SpawnPrefab("caster_ring_fx").Transform:SetPosition(x-6,y,bbb)
        SpawnPrefab("caster_ring_fx").Transform:SetPosition(x+6,y,bbb)
      end

          for ccc = x-12, x+12, 1 do
        SpawnPrefab("caster_ring_fx").Transform:SetPosition(ccc,y,z-12)
        SpawnPrefab("caster_ring_fx").Transform:SetPosition(ccc,y,z+12)
      end
      for ddd = z-12, z+12, 1 do
        SpawnPrefab("caster_ring_fx").Transform:SetPosition(x-12,y,ddd)
        SpawnPrefab("caster_ring_fx").Transform:SetPosition(x+12,y,ddd)
      end

     end
   --if attacker.components.sanity > 300 then
   --if not skipsanity and attacker ~= nil and attacker.components.sanity ~= nil then
    attacker.components.sanity:DoDelta(-30)
    attacker.components.health:DoDelta(-25)

    local x, y, z = attacker.Transform:GetWorldPosition()
    local range = 25
    --inst.components.finiteuses:Use(1)

    local ents = TheSim:FindEntities(x, y, z, range)
    for i, v in ipairs(ents) do
        if v.components.health and not v:HasTag("player") then
            v.components.health:DoDelta(-1000)
        elseif v:HasTag("smashable") then
            v.components.health:Kill()
        elseif v.components.workable ~= nil and v.components.workable.workleft > 0 then
            SpawnPrefab("collapse_small").Transform:SetPosition(v.Transform:GetWorldPosition())
            v.components.workable:Destroy(inst)
        end
    end
    
--elseif attacker.components.health ~= nil then
  --  attacker.components.health:DoDelta(-10)
--end
return true

end
  
local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
     local light2 = inst.entity:AddLight()
    light2:SetFalloff(.3)
    light2:SetIntensity(.8)
    light2:SetRadius(3)
    light2:Enable(true)
    light2:SetColour(255/255, 88/255, 112/255)   
end

local function linkToBuilder(inst, builder)
	-- sound and anim reactions
	if builder then
		SpawnPrefab("mossling_spin_fx").Transform:SetPosition(inst:GetPosition():Get())
	end
end
 
local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	inst.entity:AddMiniMapEntity()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("galientsword")
    inst.AnimState:SetBuild("galientsword")
    inst.AnimState:PlayAnimation("idle")
	
    inst.MiniMapEntity:SetIcon("galientsword.tex")
 
    inst:AddTag("sharp")
 
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(888)
	inst.components.weapon:SetOnAttack(onattack_galient)
  
    inst:AddComponent("inspectable")
      
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "galientsword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/galientsword.xml"
	
    --inst:AddComponent("perishable")
   -- inst.components.perishable:SetPerishTime(1.5*30*16*2)
    --inst.components.perishable:StartPerishing()
   -- inst.components.perishable:SetOnPerishFn(inst.Remove)
	      
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

   -- inst:AddComponent("characterspecific")
    --inst.components.characterspecific:SetOwner("archer")
	
    if not inst.components.characterspecific then
    inst:AddComponent("characterspecific")
end
 
    inst.components.characterspecific:SetOwner("archer")
    inst.components.characterspecific:SetStorable(true)
    inst.components.characterspecific:SetComment("I don't feel safe near this...") 


	inst.OnBuilt = linkToBuilder
     
    return inst
end
return  Prefab("common/inventory/archer_galientsword", fn, assets) 