local assets=
{
    Asset("ANIM", "anim/gkatana.zip"),
    Asset("ANIM", "anim/swap_gkatana.zip"),
  
    Asset("ATLAS", "images/inventoryimages/gkatana.xml"),
    Asset("IMAGE", "images/inventoryimages/gkatana.tex"),
}

local prefabs = 
{
}

local function onblink(staff, pos, caster)
    if caster.components.sanity ~= nil then
        caster.components.sanity:DoDelta(-5)
    end
 
end

local function blinkstaff_reticuletargetfn()
    local player = ThePlayer
    local rotation = player.Transform:GetRotation() * DEGREES
    local pos = player:GetPosition()
    for r = 13, 1, -1 do
        local numtries = 2 * PI * r
        local pt = FindWalkableOffset(pos, rotation, r, numtries)
        if pt ~= nil then
            return pt + pos
        end
    end
end


local function onattack(inst, owner, target)
    local pt = owner:GetPosition()
    if target.components.health then
       target.Transform:SetPosition(pt.x+1, pt.y, pt.z)
    end
    --inst:DoTaskInTime(0.1, function() 
    --target.components.health:DoDelta(-3000)
    --end)
end


local function OnEquip(inst, owner)
--   owner.components.combat:SetAreaDamage(7, 1)
    owner.AnimState:OverrideSymbol("swap_object", "swap_gkatana", "swap_gkatana")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function OnUnequip(inst, owner)
--   owner.components.combat:SetAreaDamage(nil, nil)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function linkToBuilder(inst, builder)
	-- sound and anim reactions
	if builder then
		SpawnPrefab("mossling_spin_fx").Transform:SetPosition(inst:GetPosition():Get())
	end
end
 
local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("gkatana")
    inst.AnimState:SetBuild("gkatana")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")
 
     inst:AddComponent("reticule")
    inst.components.reticule.targetfn = blinkstaff_reticuletargetfn
    inst.components.reticule.ease = true

    if not TheWorld.ismastersim then
        return inst
    end

  
    inst.castsound = "dontstarve/common/staffteleport"

    inst:AddComponent("blinkstaff")
    inst.components.blinkstaff.onblinkfn = onblink
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetOnAttack(onattack)

	
    inst:AddComponent("inspectable")
      
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "gkatana"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/gkatana.xml"
	
    inst:AddComponent("perishable")
   inst.components.perishable:SetPerishTime(30*20*5)
    inst.components.perishable:StartPerishing()
    inst.components.perishable:SetOnPerishFn(inst.Remove)
      
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.OnBuilt = linkToBuilder
   
    return inst
end
return  Prefab("common/inventory/archer_gkatana", fn, assets, prefabs) 