local assets=
{
    Asset("ANIM", "anim/pearlspear.zip"),
    Asset("ANIM", "anim/swap_pearlspear.zip"),
  
    Asset("ATLAS", "images/inventoryimages/pearlspear.xml"),
    Asset("IMAGE", "images/inventoryimages/pearlspear.tex"),
}

local prefabs = 
{
}




local function OnDropped(inst)
    inst.AnimState:PlayAnimation("idle")
end

--local function OnCaught(inst, catcher)
 --   if catcher then
--        if catcher.components.inventory then
          --  if inst.components.equippable and not catcher.components.inventory:GetEquippedItem(inst.components.equippable.equipslot) then
           --     catcher.components.inventory:Equip(inst)
          --  else
           --     catcher.components.inventory:GiveItem(inst)
          --  end
           -- catcher:PushEvent("catch")
--       end
--    end
--end

--local function OnThrown(inst, owner)
--inst.AnimState:PlayAnimation("planted")
--end

local function onattack(inst, attacker, target, skipsanity)
    if not skipsanity and attacker ~= nil and attacker.components.sanity ~= nil then
        attacker.components.sanity:DoDelta(-5)
    end

    if not target:IsValid() then
        --target killed or removed in combat damage phase
        return
    end

    if target.components.sleeper ~= nil and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end

    if target.components.burnable ~= nil then
        if target.components.burnable:IsBurning() then
            target.components.burnable:Extinguish()
        elseif target.components.burnable:IsSmoldering() then
            target.components.burnable:SmotherSmolder()
        end
    end

    if target.components.combat ~= nil then
        target.components.combat:SuggestTarget(attacker)
    end

    if target.sg ~= nil and not target.sg:HasStateTag("frozen") then
        target:PushEvent("attacked", { attacker = attacker, damage = 0 })
    end

    if target.components.freezable ~= nil then
        target.components.freezable:AddColdness(10)
        target.components.freezable:SpawnShatterFX()
    end
end

--local function OnHit(inst, owner, target)
 --   OnDropped(inst)
   -- local pos = Vector3(target.Transform:GetWorldPosition())

--
local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_pearlspear", "swap_pearlspear")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end
  
local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function linkToBuilder(inst, builder)
	-- sound and anim reactions
	if builder then
		SpawnPrefab("mossling_spin_fx").Transform:SetPosition(inst:GetPosition():Get())
	end
end
 
local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("pearlspear")
    inst.AnimState:SetBuild("pearlspear")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")
 
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)

    inst.components.weapon:SetOnAttack(onattack)
  
    inst:AddComponent("inspectable")
      
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "pearlspear"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/pearlspear.xml"
	
    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(1*3*10*2)
    inst.components.perishable:StartPerishing()
    inst.components.perishable:SetOnPerishFn(inst.Remove)
      
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.OnBuilt = linkToBuilder
     
    return inst
end
return  Prefab("common/inventory/archer_pearlspear", fn, assets) 