local assets=
{
    Asset("ANIM", "anim/sandai.zip"),
    Asset("ANIM", "anim/swap_sandai.zip"),
  
    Asset("ATLAS", "images/inventoryimages/sandai.xml"),
    Asset("IMAGE", "images/inventoryimages/sandai.tex"),
}

local prefabs = 
{
}

local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_sandai", "swap_sandai")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end
  
local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function linkToBuilder(inst, builder)
	-- sound and anim reactions
	if builder then
		SpawnPrefab("mossling_spin_fx").Transform:SetPosition(inst:GetPosition():Get())
	end
end
 
local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("sandai")
    inst.AnimState:SetBuild("sandai")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")
 
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(1)

    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 10)
    inst.components.tool:SetAction(ACTIONS.MINE, 3)
    inst.components.tool:SetAction(ACTIONS.HAMMER,3)
    inst.components.tool:SetAction(ACTIONS.DIG)

	
    inst:AddComponent("inspectable")
      
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "sandai"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/sandai.xml"
	
    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(30*5*2)
    inst.components.perishable:StartPerishing()
    inst.components.perishable:SetOnPerishFn(inst.Remove)
      
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.OnBuilt = linkToBuilder
   
    return inst
end
return  Prefab("common/inventory/archer_sandai", fn, assets, prefabs) 