local assets=
{
    Asset("ANIM", "anim/sanspear.zip"),
    Asset("ANIM", "anim/swap_sanspear.zip"),
  
    Asset("ATLAS", "images/inventoryimages/sanspear.xml"),
    Asset("IMAGE", "images/inventoryimages/sanspear.tex"),
}

local prefabs = 
{
	"zoro"
}

local function OnDropped(inst)
    inst.AnimState:PlayAnimation("idle")
end

local function OnCaught(inst, catcher)
    if catcher then
        if catcher.components.inventory then
            if inst.components.equippable and not catcher.components.inventory:GetEquippedItem(inst.components.equippable.equipslot) then
                catcher.components.inventory:Equip(inst)
            else
                catcher.components.inventory:GiveItem(inst)
            end
            catcher:PushEvent("catch")
        end
    end
end

local function OnThrown(inst, owner)
inst.AnimState:PlayAnimation("planted")
end



local function OnHit(inst, owner, target)
    OnDropped(inst)
    local pos = Vector3(target.Transform:GetWorldPosition())

end

local function OnEquip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_sanspear", "swap_sanspear")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end
  
local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

--local function linkToBuilder(inst, builder)
	-- sound and anim reactions
--	if builder then
	--	SpawnPrefab("mossling_spin_fx").Transform:SetPosition(inst:GetPosition():Get())
	--end
--end
 
local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("sanspear")
    inst.AnimState:SetBuild("sanspear")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")
 
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(300)

       inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(100)
    inst.components.projectile:SetCanCatch(true)
    inst.components.projectile:SetHoming(true)
    inst.components.projectile:SetOnThrownFn(OnThrown)
    inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnCaughtFn(OnCaught)
      
	  
    inst:AddComponent("inspectable")
	
    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(15*16*2)
    inst.components.perishable:StartPerishing()
    inst.components.perishable:SetOnPerishFn(inst.Remove)
      
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "sanspear"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/sanspear.xml"

      inst:AddComponent("stackable")  
      
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	--inst.components.inventoryitem.keepondeath = true
    inst.components.equippable.equipstack = true

    local light = inst.entity:AddLight()
    light:SetFalloff(.3)
    light:SetIntensity(.8)
    light:SetRadius(2)
    light:Enable(true)
    light:SetColour(255/255, 88/255, 112/255)
	
	--inst.OnBuilt = linkToBuilder
	     
    return inst
end
return  Prefab("common/inventory/archer_sanspear", fn, assets, prefabs) 