local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),


}
local prefabs = {
	"gate_of_babylon",
}

-- Custom starting items
local start_inv = {
"gate_of_babylon",
"gate_of_babylon",
"gate_of_babylon",

}

local function onbecamehuman(inst)
	inst.components.locomotor.walkspeed = TUNING.GILGAMESH_WALKSPEED
	inst.components.locomotor.runspeed = TUNING.GILGAMESH_RUNSPEED
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "gilgamesh.tex" )
	inst:AddTag("gilgameshbuilder")
	
end

 local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "gilgamesh"

        inst.components.health:SetMaxHealth(TUNING.GILGAMESH_HEALTH)
        inst.components.hunger:SetMax(TUNING.GILGAMESH_HUNGER)
        inst.components.sanity:SetMax(TUNING.GILGAMESH_SANITY)
        inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE *0.3)
        inst.components.health.absorb = TUNING.GILGAMESH_ARMOR
        
        inst.components.combat.min_attack_period =0.1
        inst.components.locomotor.walkspeed = (TUNING.GILGAMESH_WALKSPEED)
	    inst.components.locomotor.runspeed = (TUNING.GILGAMESH_RUNSPEED)
        inst.components.combat:SetDefaultDamage(TUNING.GILGAMESH_ATTACK)
        inst.components.combat:SetRange(30,40)

        inst.components.sanity.night_drain_mult=0
        inst.components.sanity.neg_aura_mult=0

        inst.OnLoad = onload
        inst.OnNewSpawn = onload


local _DoBuild = inst.components.builder.DoBuild
        inst.components.builder.DoBuild = function( self, recname, pt, rotation, skin )
        
        if self.inst.components.sanity.current < 10 then
                return false
        end

        return _DoBuild(self, recname, pt, rotation, skin)

    end

return MakePlayerCharacter("archer", prefabs, assets, common_postinit, master_postinit, start_inv)