local assets=
{
	Asset("ANIM", "anim/gilgamesh.zip"),
    Asset("ANIM", "anim/archer.zip"),
    Asset( "ANIM", "anim/player_basic.zip" ),
	Asset( "ANIM", "anim/player_idles_shiver.zip" ),
	Asset( "ANIM", "anim/player_actions.zip" ),
	Asset( "ANIM", "anim/player_actions_axe.zip" ),
	Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
	Asset( "ANIM", "anim/player_actions_shovel.zip" ),
	Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
	Asset( "ANIM", "anim/player_actions_eat.zip" ),
	Asset( "ANIM", "anim/player_actions_item.zip" ),
	Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
	Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
	Asset( "ANIM", "anim/player_actions_fishing.zip" ),
	Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
	Asset( "ANIM", "anim/player_bush_hat.zip" ),
	Asset( "ANIM", "anim/player_attacks.zip" ),
	Asset( "ANIM", "anim/player_idles.zip" ),
	Asset( "ANIM", "anim/player_rebirth.zip" ),
	Asset( "ANIM", "anim/player_jump.zip" ),
	Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
	Asset( "ANIM", "anim/player_teleport.zip" ),
	Asset( "ANIM", "anim/wilson_fx.zip" ),
	Asset( "ANIM", "anim/player_one_man_band.zip" ),
}
-----------------------------------------------------------------------------------------------------------
----	重定位目标
local function RetargetFn(inst)
    local invader = nil
    invader = FindEntity(inst, 30, function(guy)
        return guy:HasTag("monster") and not guy:HasTag("player") and not guy:HasTag("kings") 
    end)
	----	敌视语句
--
end

local function KeepTargetFn(inst, target)
    return inst.components.combat:CanTarget(target)     
end
-------------------------------------------------------------------------------------------------------------
SetSharedLootTable( 'happypeople',
{
	{'kingarmor',          0.10},

	{'armorwood',          0.30},
	{'armorwood',          0.30},

	{'turkeydinner',          0.50},
	{'turkeydinner',          0.50},
	{'turkeydinner',          0.50},
	{'turkeydinner',          0.50},
	

})
-----------------------------------------------------------------------------------------------------

local function ShouldAcceptItem(inst, item)
    if item.components.equippable ~= nil and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
        return true
    elseif item.components.edible ~= nil then
        local foodtype = item.components.edible.foodtype
        if foodtype == FOODTYPE.MEAT or foodtype == FOODTYPE.HORRIBLE then
            return inst.components.follower.leader == nil or inst.components.follower:GetLoyaltyPercent() <= 0.9
        elseif foodtype == FOODTYPE.VEGGIE or foodtype == FOODTYPE.RAW then
            local last_eat_time = inst.components.eater:TimeSinceLastEating()
            return (last_eat_time == nil or
                    last_eat_time >= TUNING.PIG_MIN_POOP_PERIOD)
                and (inst.components.inventory == nil or
                    not inst.components.inventory:Has(item.prefab, 1))
        end
        return true
    end
end

local function OnGetItemFromPlayer(inst, giver, item)
    --I eat food
    if item.components.edible ~= nil then
        --meat makes us friends (unless I'm a guard)
        if item.components.edible.foodtype == FOODTYPE.MEAT or item.components.edible.foodtype == FOODTYPE.HORRIBLE then
            if inst.components.combat:TargetIs(giver) then
                inst.components.combat:SetTarget(nil)
            elseif giver.components.leader ~= nil and not inst:HasTag("guard") then
                giver:PushEvent("makefriend")
                giver.components.leader:AddFollower(inst)
                inst.components.follower:AddLoyaltyTime(item.components.edible:GetHunger() * TUNING.PIG_LOYALTY_PER_HUNGER)
                inst.components.follower.maxfollowtime =
                    giver:HasTag("polite")
                    and TUNING.PIG_LOYALTY_MAXTIME + TUNING.PIG_LOYALTY_POLITENESS_MAXTIME_BONUS
                    or TUNING.PIG_LOYALTY_MAXTIME
            end
        end
        if inst.components.sleeper:IsAsleep() then
            inst.components.sleeper:WakeUp()
        end
    end

    --I wear hats
    if item.components.equippable ~= nil and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
        local current = inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
        if current ~= nil then
            inst.components.inventory:DropItem(current)
        end
        inst.components.inventory:Equip(item)
        inst.AnimState:Show("hat")
    end
end

local function OnRefuseItem(inst, item)
    inst.sg:GoToState("refuse")
    if inst.components.sleeper:IsAsleep() then
        inst.components.sleeper:WakeUp()
    end
end

local function OnEat(inst, food)
    if food.components.edible ~= nil then
        if food.components.edible.foodtype == FOODTYPE.VEGGIE then
            SpawnPrefab("goldnugget").Transform:SetPosition(inst.Transform:GetWorldPosition())
       -- elseif food.components.edible.foodtype == FOODTYPE.MEAT and
           -- inst.components.werebeast ~= nil and
          --  not inst.components.werebeast:IsInWereState() and
           -- food.components.edible:GetHealth(inst) < 0 then
           -- inst.components.werebeast:TriggerDelta(1)
        end
    end
end

local function OnNewTarget(inst, data)
    if inst:HasTag("werepig") then
        inst.components.combat:ShareTarget(data.target, SHARE_TARGET_DIST, IsWerePig, MAX_TARGET_SHARES)
    end
end

local builds = { "pig_build", "pigspotted_build" }
--local guardbuilds = { "pig_guard_build" }

local function NormalRetargetFn(inst)
    return FindEntity(
        inst,
        TUNING.PIG_TARGET_DIST,
        function(guy)
            return (guy.LightWatcher == nil or guy.LightWatcher:IsInLight())
                and inst.components.combat:CanTarget(guy)
        end,
        { "monster", "_combat" }, -- see entityreplica.lua
        inst.components.follower.leader ~= nil and
        { "playerghost", "INLIMBO", "abigail" } or
        { "playerghost", "INLIMBO" }
    )
end

local function NormalKeepTargetFn(inst, target)
    --give up on dead guys, or guys in the dark, or werepigs
    return inst.components.combat:CanTarget(target)
        and (target.LightWatcher == nil or target.LightWatcher:IsInLight())
        and not (target.sg ~= nil and target.sg:HasStateTag("transform"))
end

local function NormalShouldSleep(inst)
    return DefaultSleepTest(inst)
        and (inst.components.follower == nil or inst.components.follower.leader == nil
            or (FindEntity(inst, 6, nil, { "campfire", "fire" }) ~= nil and
                (inst.LightWatcher == nil or inst.LightWatcher:IsInLight())))
end

local normalbrain = require "brains/happypeoplebrain"

local function oncollide(inst, other)
	if not other then
		return
	else
		if not other:IsValid() then
			return
		end
		----遇到障碍物就跳跃
	--	if inst.components.health and not inst.components.health:IsDead() and not (other:HasTag("player") or other:HasTag("projectile") or other:HasTag("character")) then
		--	inst.sg:GoToState("jump")
		--end
	end
end

----	击中玩家	特点	--模板
local function onattack(inst,data)
    local victim = data.target
	if victim and victim:HasTag("player") then
		----僵直一下
		if not victim.components.health:IsDead() then
			victim.sg:GoToState("idle")
		end
	end
end

----	被攻击时
local function OnAttacked(inst, data)
	
	
	----	群体反攻玩家
    local attacker = data and data.attacker
	if attacker then
		if inst.components.combat:CanTarget(attacker) and not attacker:HasTag("kings") then
			inst.components.combat:SetTarget(attacker)
			----	小伙伴何在
			inst.components.combat:ShareTarget(attacker, 100, function(dude)
				return dude:HasTag("kings")	
			end, 20)
		end
	end
end
-----------------------------------------------------------------
-----------------------------------------------------------------
----	武器样式
local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_gkatana", "swap_gkatana")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end
local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

----	武器栏
local function GetInventory(inst)
    if inst.components.inventory ~= nil and not inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) then
        local meleeweapon = CreateEntity()
        meleeweapon.entity:AddTransform()
        meleeweapon:AddComponent("weapon")
        meleeweapon.components.weapon:SetDamage(50)
        meleeweapon:AddComponent("inventoryitem")
        meleeweapon.persists = false
        meleeweapon.components.inventoryitem:SetOnDroppedFn(inst.Remove)
        meleeweapon:AddComponent("equippable")
			----	武器外观
			meleeweapon.components.equippable:SetOnEquip(onequip)
			meleeweapon.components.equippable:SetOnUnequip(onunequip)
        meleeweapon:AddTag("meleeweapon")
		inst.components.inventory:Equip(meleeweapon)
    end
end



local function fn()
 --  outfit =GetModConfigData("outfit")

	local inst = CreateEntity()
--	 outfit =GetModConfigData("outfit")
	inst.entity:AddTransform()
	inst.Transform:SetFourFaced()
	
	inst.entity:AddAnimState()
	inst.AnimState:SetBank("wilson")
--	 if outfit then
    --    if outfit == 1 then
     --inst.AnimState:SetBuild("archer")
   -- else if outfit ==0 then
      inst.AnimState:SetBuild("gilgamesh")
  --  end
--end
--end
	inst.AnimState:PlayAnimation("idle")
	--inst.AnimState:OverrideSymbol("swap_hat", "hat_feather", "swap_hat")
	inst.AnimState:Show("HAT")
	inst.AnimState:Show("HAT_HAIR")
	inst.AnimState:Hide("HAIR_NOHAT")
	inst.AnimState:Hide("HAIR")
	inst.AnimState:OverrideSymbol("swap_body", "armor_wood", "swap_body")
	--inst.AnimState:OverrideSymbol("beard", "beard", "beard_long")
	
	local phys = inst.entity:AddPhysics()
	phys:SetMass(100)
    phys:SetCapsule(.5, 1.5)
    phys:SetFriction(0)
    phys:SetDamping(5)
    phys:SetCollisionGroup(COLLISION.CHARACTERS)
    phys:ClearCollisionMask()
	phys:CollidesWith(COLLISION.GROUND)
	phys:CollidesWith(COLLISION.OBSTACLES)
    phys:CollidesWith(COLLISION.SMALLOBSTACLES)
	phys:CollidesWith(COLLISION.CHARACTERS)

	inst.entity:AddSoundEmitter()
	inst.entity:AddLightWatcher()
	
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 2, 1 )
	
	inst.entity:AddNetwork()

	inst:AddTag("healthinfo")

	inst:AddTag("kings")
	 inst:AddTag("trader")

	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end 
	
	----	碰撞
	inst.Physics:SetCollisionCallback(oncollide)
	
	----	不会中毒，共性
    inst:AddComponent("eater")  
	inst.components.eater:SetDiet({ FOODGROUP.OMNI }, { FOODGROUP.OMNI})
    inst.components.eater.strongstomach = true
	
	local selfeater = inst.components.eater
	local old = selfeater.Eat
	

	function inst.components.eater:Eat(food)
		if selfeater:CanEat(food) then
			if food.components.edible.healthvalue < 1 then
				food.components.edible.healthvalue = 1
			end
		end
		return old(selfeater, food)
	end

	----	移动，共性
    inst:AddComponent("locomotor")
    inst.components.locomotor.walkspeed= 5
    inst.components.locomotor.runspeed = 8
	inst.components.locomotor.fasteronroad = true
	inst.components.locomotor:SetTriggersCreep(false)
	
	--inst.NumPerdsToSpawn = NumPerdsToSpawn
	
	----	状态图和AI
    inst:SetStateGraph("SGhappypeople")

    local brain = require "brains/happypeoplebrain"
    inst:SetBrain(brain)
    
	-------------------------------------------------------------------------------------------------------
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(205)
	inst.components.health:StartRegen(10, 30)
	inst.components.health.fire_damage_scale = 0.8
	--inst.components.health.destroytime = 5
	----	防御力
	inst.components.health:SetAbsorptionAmount(.7)
    
    inst:AddComponent("knownlocations")
    inst:AddComponent("inventory")
	
    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = -TUNING.SANITYAURA_MED * 3
    
	inst:AddComponent("talker")
	
	inst:AddComponent("leader")
  
	----	战斗
    inst:AddComponent("combat")
    inst.components.combat:SetDefaultDamage(100)						----常常不是空手, 因此无用
    inst.components.combat:SetAttackPeriod(3)
    --inst.components.combat:SetRange(3)
    inst.components.combat.hiteffectsymbol = "torso"
    inst.components.combat:SetRetargetFunction(2, RetargetFn)
    inst.components.combat:SetKeepTargetFunction(KeepTargetFn)
	
	----	攻击特效
	inst:ListenForEvent("onattackother", onattack)
	
	--
    inst:AddComponent("lootdropper")
	----	掉落
	inst.components.lootdropper:SetChanceLootTable('happypeople')
	
	----	监听事件
    inst:ListenForEvent("attacked", OnAttacked)
	
	----	武器
	GetInventory(inst)
inst:AddComponent("sleeper")
	 inst.components.sleeper:SetResistance(2)
	 inst.components.sleeper:SetSleepTest(NormalShouldSleep)
    inst.components.sleeper:SetWakeTest(DefaultWakeTest)



    inst:AddComponent("bloomer")

    ------------------------------------------
    inst:AddComponent("eater")
    inst.components.eater:SetDiet({ FOODGROUP.OMNI }, { FOODGROUP.OMNI })
    inst.components.eater:SetCanEatHorrible()
    inst.components.eater:SetCanEatRaw()
    inst.components.eater.strongstomach = true -- can eat monster meat!
    inst.components.eater:SetOnEatFn(OnEat)
    ------------------------------------------

    MakeMediumBurnableCharacter(inst, "pig_torso")

    inst:AddComponent("named")
    inst.components.named.possiblenames = STRINGS.PIGNAMES
    inst.components.named:PickNewName()
    inst:AddComponent("follower")
    inst.components.follower.maxfollowtime = TUNING.PIG_LOYALTY_MAXTIME
    ------------------------------------------
    inst:AddComponent("trader")

        inst.components.trader:Enable()
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader.onrefuse = OnRefuseItem
    inst.components.trader.deleteitemonaccept = false
    
    
    inst:AddComponent("inspectable")
	inst.components.inspectable:SetDescription("至高无上的王创造了他们，给了他们无限可能性。")
	
    return inst
end

STRINGS.NAMES.HAPPYPEOPLE= "王愉悦的子民" 
return Prefab ("happypeople", fn, assets)