/**
* Given an inventory, removes its weapons
* that are below relic tier and are not
* quest items
*
* @param inventory the inventory component to have its junk weapons removed
* @return removes junk weapons from the given inventory
*/

function modNoJunkWeaponDropsRemoveInventoryJunkWeapons(inventory : CInventoryComponent)
{
	var i : int;
	var ids : array<SItemUniqueId>;
	
	ids = inventory.GetWeapons();
	
	for(i=0; i<ids.Size(); i+=1)
	{
		if(inventory.GetItemQuality(ids[i])<4 && !inventory.IsItemQuest(ids[i]))
		{
			inventory.RemoveItem(ids[i]);
		}
	}
	
}
