PrefabFiles = {
	"hk",
	"hkrang",
	"hkdart",
	"hkadm"
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/hk.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/hk.xml" ),
    Asset( "IMAGE", "images/selectscreen_portraits/hk.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/hk.xml" ),
    Asset( "IMAGE", "images/selectscreen_portraits/hk_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/hk_silho.xml" ),
    Asset( "IMAGE", "bigportraits/hk.tex" ),
    Asset( "ATLAS", "bigportraits/hk.xml" ),
	Asset( "IMAGE", "images/map_icons/hk.tex" ),
	Asset( "ATLAS", "images/map_icons/hk.xml" ),
	Asset("ATLAS", "images/inventoryimages/droidtab.xml")
}

local require = GLOBAL.require

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local InvSlot = require "widgets/invslot"
local TileBG = require "widgets/tilebg"
local Image = require "widgets/image"
local Widget = require "widgets/widget"
local EquipSlot = require "widgets/equipslot"
local ItemTile = require "widgets/itemtile"

STRINGS.TABS.DROID = "Droid"
GLOBAL.RECIPETABS['DROID'] = {str = "DROID", sort=0, icon = "droidtab.tex", icon_atlas = "images/inventoryimages/droidtab.xml"}

STRINGS.NAMES.HKRANG = "Vibro-rang"
STRINGS.RECIPE_DESC.HKRANG = "A flying vibroblade."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HKRANG = "Warning: Catch it or lose it."

STRINGS.NAMES.HKDART = "Aratech Blow Gun"
STRINGS.RECIPE_DESC.HKDART = "Love is knowing your target."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HKDART = "Statement: Aim for the knees."

STRINGS.NAMES.HKADM = "A.D.M."
STRINGS.RECIPE_DESC.HKADM = "Assassin Droid Module"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HKADM = "Statement: Upgrade available."

function LinkPostInit(hk)

        local hkrangrecipe = GLOBAL.Recipe( "hkrang", { Ingredient("gears", 1), Ingredient("redgem", 1)}, RECIPETABS.DROID, {SCIENCE = 0})
        hkrangrecipe.atlas = "images/inventoryimages/hkrang.xml"
		local hkdartrecipe = GLOBAL.Recipe( "hkdart", { Ingredient("blowdart_pipe", 1), Ingredient("gears", 1), Ingredient("redgem", 1)}, RECIPETABS.DROID, {SCIENCE = 0})
        hkdartrecipe.atlas = "images/inventoryimages/hkdart.xml"
		local hkadmrecipe = GLOBAL.Recipe( "hkadm", { Ingredient("gears", 1), Ingredient("purplegem", 2), Ingredient("goldnugget", 1)}, RECIPETABS.DROID, {SCIENCE = 0})
        hkadmrecipe.atlas = "images/inventoryimages/hkadm.xml"
        
end

AddSimPostInit(function(inst)
        if inst.prefab == "hk" then
                LinkPostInit(inst)
        end
end)


-- The character select screen lines
GLOBAL.STRINGS.CHARACTER_TITLES.hk = "The Assassin Droid"
GLOBAL.STRINGS.CHARACTER_NAMES.hk = "HK-47"
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.hk = "*Hunter/Killer\n*Rusty Red\n*Upgrade Pack"
GLOBAL.STRINGS.CHARACTER_QUOTES.hk = "\"Shall we find something to kill to cheer ourselves up?\""

-- Custom speech strings
GLOBAL.STRINGS.CHARACTERS.HK = require "speech_hk"

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.ROBOT, "hk")


AddMinimapAtlas("images/map_icons/hk.xml")
AddModCharacter("hk")

