
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/hk.zip" ),
}
local prefabs = 
{
		"sparks"
}
local start_inv = {
	"hkrang"
}


local function applyupgrades(inst)
	
	local	HK_MIN_HEALTH = 100
	local HK_MIN_SANITY = 100
	local HK_MIN_HUNGER = 150

	local HK_MAX_HEALTH = 300
	local HK_MAX_SANITY = 150
	local HK_MAX_HUNGER = 250
	
	
    local max_upgrades = 10
    inst.level = math.min(inst.level, max_upgrades)

    local hunger_percent = inst.components.hunger:GetPercent()
    local health_percent = inst.components.health:GetPercent()
    local sanity_percent = inst.components.sanity:GetPercent()

    inst.components.hunger.max = math.ceil(HK_MIN_HUNGER + inst.level * (HK_MAX_HUNGER - HK_MIN_HUNGER)/max_upgrades)
    inst.components.health.maxhealth = math.ceil(HK_MIN_HEALTH + inst.level * (HK_MAX_HEALTH - HK_MIN_HEALTH)/max_upgrades)
    inst.components.sanity.max = math.ceil(HK_MIN_SANITY + inst.level * (HK_MAX_SANITY - HK_MIN_SANITY)/max_upgrades)
    inst.components.hunger:SetPercent(hunger_percent)
    inst.components.health:SetPercent(health_percent)
    inst.components.sanity:SetPercent(sanity_percent)
	
end

local function applyupgradedamage(inst)
	
	local HK_MIN_DMP = 1
	local HK_MAX_DMP = 1.5
	local max_dmg_upgrades = 5
	inst.components.combat.damagemultiplier = math.ceil(HK_MIN_DMP + inst.dmglevel * (HK_MAX_DMP - HK_MIN_DMP)/max_dmg_upgrades)
	
end

local function oneat(inst, food)
	
	if food and food.components.edible and food.components.edible.foodtype == "GEARS" then
		--give an upgrade!
		inst.level = inst.level + 1
		applyupgrades(inst)	
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()
		
		inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
	end
	
	if food and food.components.edible and food.components.edible.foodtype == "ADM" then
		inst.dmglevel = inst.dmglevel + 1
		applyupgradedamage(inst)	
		inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()
		
		inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
	end
end

local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			--re-set these from the save data, because of load-order clipping issues
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
		if data.dmglevel then
			inst.dmglevel = data.dmglevel
			applyupgradedamage(inst)
		end
	end

end

local function onsave(inst, data)
	data.level = inst.level
	data.dmglevel = inst.dmglevel
end

local function dorainsparks(inst, dt)

    if (inst.components.moisture and inst.components.moisture:GetMoisture() > 0) then
    	inst.spark_time = inst.spark_time - dt

    	if inst.spark_time <= 0 then
    		
    		--GetClock():DoLightningLighting()
    		inst.spark_time = 3+math.random()*2

    		local pos = Vector3(inst.Transform:GetWorldPosition())
    		local damage = nil

    		-- Raining, no moisture-giving equipment on head, and moisture is increasing. Pro-rate damage based on waterproofness.
    		if GetSeasonManager():IsRaining() and inst.components.inventory:GetEquippedMoistureRate(EQUIPSLOTS.HEAD) <= 0 and inst.components.moisture:GetDelta() > 0 then
	    		local waterproofmult = (inst.components.moisture and inst.components.moisture.sheltered and inst.components.inventory) and (1 - (inst.components.inventory:GetWaterproofness() + inst.components.moisture.shelter_waterproofness)) or (inst.components.inventory and (1 - inst.components.inventory:GetWaterproofness()) or 1)
	    		damage = waterproofmult > 0 and math.min(0, -3 * waterproofmult) or 0
	    		inst.components.health:DoDelta(damage, false, "rain")
				pos.y = pos.y + 1 + math.random()*1.5
	    	else -- We have moisture-giving equipment on our head or it is not raining and we are just passively wet (but drying off). Do full damage.
	    		if inst.components.moisture:GetDelta() >= 0 then -- Moisture increasing (wearing something moisturizing)
	    			inst.components.health:DoDelta(-3, false, "water")
	    		else -- Drying damage
	    			inst.components.health:DoDelta(-1, false, "water")
	    		end
				pos.y = pos.y + .25 + math.random()*2
	    	end
			
			if not damage or (damage and damage < 0) then
				local spark = SpawnPrefab("sparks")
				spark.Transform:SetPosition(pos:Get())
			end
    	end
    end
end
local function dofreezersparks(inst, dt)

	local mitigates_cold = false
	for k,v in pairs (inst.components.inventory.equipslots) do
		if v.components.insulator then
				mitigates_cold = true
		end		
	end

	if inst.components.temperature.current <= 25 and GetSeasonManager() and GetSeasonManager():IsWinter() and not mitigates_cold then
		inst.spark_time = inst.spark_time - dt
	
    	if inst.spark_time <= 0 then
    		inst.spark_time = 3+math.random()*2
    		inst.components.health:DoDelta(-1, false, "rain")
			local pos = Vector3(inst.Transform:GetWorldPosition())
			pos.y = pos.y + 1 + math.random()*1.5
			local spark = SpawnPrefab("sparks")
			spark.Transform:SetPosition(pos:Get())
		end
	end
	
end

local fn = function(inst)
	inst.level = 0
	inst.spark_time = 3
	inst.dmglevel = 0
	
	
	table.insert(inst.components.eater.foodprefs, "ADM")
	table.insert(inst.components.eater.ablefoods, "ADM")
	table.insert(inst.components.eater.foodprefs, "GEARS")
	table.insert(inst.components.eater.ablefoods, "GEARS")
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wx78"
	
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "hk.tex" )
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	-- Movement speed (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	
	inst:DoPeriodicTask(1/10, function() dorainsparks(inst, 1/10) end)
	inst:DoPeriodicTask(1/10, function() dofreezersparks(inst, 1/10) end)
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
end

return MakePlayerCharacter("hk", prefabs, assets, fn, start_inv)